/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.test;

import java.util.IdentityHashMap;
import junit.framework.TestCase;
import org.conqat.lib.commons.collections.IIdProvider;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.test.DeepCloneTestUtils;
import org.conqat.lib.commons.test.example.Address;
import org.conqat.lib.commons.test.example.Model;
import org.conqat.lib.commons.test.example.Order;
import org.conqat.lib.commons.test.example.Person;

public class DeepCloneTestUtilsTest
extends TestCase {
    private final Model model = new Model();
    private final IdentityHashSet<Object> elements = new IdentityHashSet();
    private final IdentityHashSet<Order> orders = new IdentityHashSet();

    public void setUp() {
        this.elements.add(this.model);
        Address addressA = new Address("Street A", "City A");
        this.elements.add(addressA);
        Address addressB = new Address("Street B", "City B");
        this.elements.add(addressB);
        Person personA = new Person("Person A", addressA, "details of person A");
        this.elements.add(personA);
        Person personB = new Person("Person B", addressB, "details of person B");
        this.elements.add(personB);
        Order order1 = new Order("Order 1", "1");
        this.elements.add(order1);
        this.orders.add(order1);
        Order order2 = new Order("Order 2", "2");
        this.elements.add(order2);
        this.orders.add(order2);
        Order order3 = new Order("Order 3", "3");
        this.elements.add(order3);
        this.orders.add(order3);
        Order order4 = new Order("Order 4", "4");
        this.elements.add(order4);
        this.orders.add(order4);
        personA.add(order1);
        personA.add(order2);
        personB.add(order3);
        personB.add(order4);
        this.model.add(personA);
        this.model.add(personB);
    }

    public void testGetAllReferencedObjects() {
        IdentityHashSet<Object> result = DeepCloneTestUtils.getAllReferencedObjects((Object)this.model, Model.class.getPackage().getName());
        DeepCloneTestUtilsTest.assertEquals((int)this.elements.size(), (int)result.size());
        DeepCloneTestUtilsTest.assertTrue((boolean)result.containsAll(this.elements));
        DeepCloneTestUtilsTest.assertTrue((boolean)this.elements.containsAll(result));
    }

    public void testGetAllReferencedObjectsByType() {
        IdentityHashSet<Order> result = DeepCloneTestUtils.getAllReferencedObjects((Object)this.model, Order.class, Model.class.getPackage().getName());
        DeepCloneTestUtilsTest.assertEquals((int)this.orders.size(), (int)result.size());
        DeepCloneTestUtilsTest.assertTrue((boolean)result.containsAll(this.orders));
        DeepCloneTestUtilsTest.assertTrue((boolean)this.orders.containsAll(result));
    }

    public void testTestDeepCloning() {
        Model clone = this.model.deepClone();
        IdentityHashMap<Object, Object> result = DeepCloneTestUtils.testDeepCloning(this.model, clone, new ModelIdProvider(), Model.class.getPackage().getName());
        DeepCloneTestUtilsTest.assertEquals((int)this.elements.size(), (int)result.size());
    }

    private class ModelIdProvider
    implements IIdProvider<String, Object> {
        private ModelIdProvider() {
        }

        @Override
        public String obtainId(Object object) {
            if (object instanceof Model) {
                return "Model";
            }
            if (object instanceof Person) {
                return ((Person)object).getName();
            }
            if (object instanceof Address) {
                return String.valueOf(((Address)object).getCity()) + ((Address)object).getStreet();
            }
            if (object instanceof Order) {
                return ((Order)object).getArticleNumber();
            }
            throw new RuntimeException("Unknown type: " + object);
        }
    }
}

