/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.test.example;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.clone.IDeepCloneable;
import org.conqat.lib.commons.test.example.Address;
import org.conqat.lib.commons.test.example.Order;

public class Person
implements IDeepCloneable {
    private final String name;
    private final Address address;
    private final ArrayList<Order> orders = new ArrayList();
    private final String details;

    public Person(String name, Address address, String details) {
        this.name = name;
        this.address = address;
        this.details = details;
    }

    private Person(Person orig) {
        this.name = orig.name;
        this.address = orig.address.deepClone();
        this.details = orig.details;
        for (Order order : orig.orders) {
            this.add(order.deepClone());
        }
    }

    public void add(Order order) {
        this.orders.add(order);
    }

    public Address getAddress() {
        return this.address;
    }

    public Order getNullOrder() {
        return null;
    }

    public Order getExceptionOrder() {
        throw new UnsupportedOperationException();
    }

    public Order[] getExceptionOrderArray() {
        throw new UnsupportedOperationException();
    }

    public List<Order> getExceptionOrderList() {
        throw new UnsupportedOperationException();
    }

    public List getRawList() {
        return Collections.EMPTY_LIST;
    }

    public String getName() {
        return this.name;
    }

    public Order[] getOrders() {
        return this.orders.toArray(new Order[0]);
    }

    public int getOrderCount() {
        return this.orders.size();
    }

    public String getDetails() {
        return this.details;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Person)) {
            return false;
        }
        Person otherPerson = (Person)other;
        if (!this.name.equals(otherPerson.name)) {
            return false;
        }
        if (!this.address.equals(otherPerson.address)) {
            return false;
        }
        if (!this.details.equals(otherPerson.details)) {
            return false;
        }
        if (this.orders.size() != otherPerson.orders.size()) {
            return false;
        }
        int i = 0;
        while (i < this.orders.size()) {
            if (!this.orders.get(i).equals(otherPerson.orders.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return 13;
    }

    @Override
    public Person deepClone() {
        return new Person(this);
    }
}

