/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.tree;

import java.util.HashSet;
import junit.framework.TestCase;
import org.conqat.lib.commons.tree.SimpleTreeNode;
import org.conqat.lib.commons.tree.SimpleTreeNodeHandler;
import org.conqat.lib.commons.tree.TreeUtils;

public class TreeUtilsTest
extends TestCase {
    public void testCreateTreeFromStrings() {
        HashSet<String> pathes = new HashSet<String>();
        pathes.add("test1/test2/test3");
        pathes.add("test4/test5/test6");
        pathes.add("test4/test7/test8");
        SimpleTreeNode root = (SimpleTreeNode)TreeUtils.createTreeFromStrings(pathes, "/", new SimpleTreeNodeHandler<String>("<root>"));
        TreeUtilsTest.assertEquals((String)"<root>", (String)((String)root.getKey()));
        SimpleTreeNode<String> test1 = root.getChild("test1");
        SimpleTreeNode<String> test2 = test1.getChild("test2");
        SimpleTreeNode<String> test3 = test2.getChild("test3");
        TreeUtilsTest.assertNotNull(test3);
        SimpleTreeNode<String> test4 = root.getChild("test4");
        SimpleTreeNode<String> test5 = test4.getChild("test5");
        SimpleTreeNode<String> test6 = test5.getChild("test6");
        TreeUtilsTest.assertNotNull(test6);
        SimpleTreeNode<String> test7 = test4.getChild("test7");
        SimpleTreeNode<String> test8 = test7.getChild("test8");
        TreeUtilsTest.assertNotNull(test8);
    }

    public void testCreateTreeFromStringsempty() {
        SimpleTreeNode root = (SimpleTreeNode)TreeUtils.createTreeFromStrings(new HashSet<String>(), "/", new SimpleTreeNodeHandler<String>("<root>"));
        TreeUtilsTest.assertEquals((String)"<root>", (String)((String)root.getKey()));
        TreeUtilsTest.assertTrue((boolean)root.getChildren().isEmpty());
    }
}

