/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.treemap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.conqat.lib.commons.treemap.IDrawingPattern;
import org.conqat.lib.commons.treemap.ITreeMapNode;
import org.conqat.lib.commons.treemap.ITreeMapRenderer;

public class FlatTreeMapRenderer
implements ITreeMapRenderer {
    @Override
    public <T> void renderTreeMap(ITreeMapNode<T> node, Graphics2D graphics) {
        if (node.getChildren().isEmpty()) {
            Rectangle2D rect = node.getLayoutRectangle();
            graphics.setColor(node.getColor());
            graphics.fill(rect);
            if (node.getDrawingPattern() != null) {
                this.drawPattern(graphics, rect, node);
            }
            graphics.setColor(Color.BLACK);
            graphics.draw(rect);
        } else {
            for (ITreeMapNode<T> child : node.getChildren()) {
                this.renderTreeMap(child, graphics);
            }
        }
    }

    private <T> void drawPattern(Graphics2D graphics, Rectangle2D rect, ITreeMapNode<T> node) {
        IDrawingPattern drawingPattern = node.getDrawingPattern();
        graphics.setColor(node.getPatternColor());
        int x = (int)rect.getMinX();
        while ((double)x <= rect.getMaxX()) {
            int y = (int)rect.getMinY();
            while ((double)y <= rect.getMaxY()) {
                if (drawingPattern.isForeground(x, y)) {
                    graphics.fill(new Rectangle(x, y, 1, 1));
                }
                ++y;
            }
            ++x;
        }
    }
}

