/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.xml;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.CCSMTestCaseBase;
import org.conqat.lib.commons.xml.IXMLElementProcessor;
import org.conqat.lib.commons.xml.XMLReader;
import org.conqat.lib.commons.xml.example.EXMLAttribute;
import org.conqat.lib.commons.xml.example.EXMLElement;
import org.conqat.lib.commons.xml.example.Model;
import org.conqat.lib.commons.xml.example.ModelPersistenceException;
import org.conqat.lib.commons.xml.example.ModelReader;
import org.conqat.lib.commons.xml.example.ModelResolver;
import org.conqat.lib.commons.xml.example.ModelUtils;
import org.xml.sax.SAXException;

public class XMLReaderTest
extends CCSMTestCaseBase {
    public void testRead() throws IOException, ModelPersistenceException {
        Model originalModel = ModelUtils.createExampleModel();
        File file = new File(this.getTmpDirectory(), "test.xml");
        ModelUtils.writeModel(originalModel, file);
        Model newModel = new Model();
        ModelReader reader = new ModelReader(file, newModel);
        reader.readModel();
        XMLReaderTest.assertTrue((boolean)originalModel.equals(newModel));
    }

    public void testIllegalModel() throws IOException {
        Model originalModel = ModelUtils.createIllegalExampleModel();
        File file = new File(this.getTmpDirectory(), "test.xml");
        ModelUtils.writeModel(originalModel, file);
        Model newModel = new Model();
        ModelReader reader = new ModelReader(file, newModel);
        try {
            reader.readModel();
            XMLReaderTest.fail((String)"expected exception");
        }
        catch (ModelPersistenceException modelPersistenceException) {
            // empty catch block
        }
    }

    public void testProcessDecendants() throws Exception {
        File testFile = this.useTestFile("test04.xml");
        OrderCounter orderCounter = new OrderCounter(testFile);
        int orderCount = orderCounter.countOrders();
        XMLReaderTest.assertEquals((int)6, (int)orderCount);
    }

    public void testApply() throws IOException, SAXException {
        File testFile = this.useTestFile("test04.xml");
        ApplyReader reader = new ApplyReader(testFile);
        String expected = "name: Person A" + StringUtils.CR + "order: 1" + StringUtils.CR + "order: 2" + StringUtils.CR + "name: Person B" + StringUtils.CR + "order: 3" + StringUtils.CR + "order: 1" + StringUtils.CR + "order: 4" + StringUtils.CR + "order: 5" + StringUtils.CR;
        XMLReaderTest.assertEquals((String)expected, (String)reader.read());
    }

    private class ApplyReader
    extends XMLReader<EXMLElement, EXMLAttribute, NeverThrownRuntimeException> {
        private final PrintWriter writer;
        private final StringWriter content;

        public ApplyReader(File file) throws IOException {
            super(file, new ModelResolver());
            this.content = new StringWriter();
            this.writer = new PrintWriter(this.content);
        }

        public String read() throws SAXException, IOException {
            this.parseFile();
            this.apply(new OrderProcessor(), new NameProcessor());
            this.writer.flush();
            return this.content.toString();
        }

        private class NameProcessor
        implements IXMLElementProcessor<EXMLElement, NeverThrownRuntimeException> {
            private NameProcessor() {
            }

            @Override
            public EXMLElement getTargetElement() {
                return EXMLElement.NAME;
            }

            @Override
            public void process() {
                ApplyReader.this.writer.println("name: " + ApplyReader.this.getText());
            }
        }

        private class OrderProcessor
        implements IXMLElementProcessor<EXMLElement, NeverThrownRuntimeException> {
            private OrderProcessor() {
            }

            @Override
            public EXMLElement getTargetElement() {
                return EXMLElement.ORDER;
            }

            @Override
            public void process() {
                ApplyReader.this.writer.println("order: " + ApplyReader.this.getIntAttribute(EXMLAttribute.ARTICLE_NUMBER));
            }
        }
    }

    private class OrderCounter
    extends XMLReader<EXMLElement, EXMLAttribute, ModelPersistenceException> {
        public OrderCounter(File file) throws IOException {
            super(file, new ModelResolver());
        }

        public int countOrders() throws ModelPersistenceException {
            try {
                this.parseFile();
            }
            catch (SAXException e) {
                throw new ModelPersistenceException("Parsing Error: " + e.getMessage());
            }
            catch (IOException e) {
                throw new ModelPersistenceException("IO Error");
            }
            OrderProcessor orderProcessor = new OrderProcessor();
            this.processDecendantElements(orderProcessor);
            return orderProcessor.getOrderCount();
        }

        private class OrderProcessor
        implements IXMLElementProcessor<EXMLElement, ModelPersistenceException> {
            private int orderCount = 0;

            private OrderProcessor() {
            }

            @Override
            public EXMLElement getTargetElement() {
                return EXMLElement.ORDER;
            }

            @Override
            public void process() {
                ++this.orderCount;
            }

            public int getOrderCount() {
                return this.orderCount;
            }
        }
    }
}

