/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.xml;

import java.io.File;
import java.io.IOException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.CCSMTestCaseBase;
import org.conqat.lib.commons.xml.XMLUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLUtilsTest
extends CCSMTestCaseBase {
    private static final String ELEMENT_NAME = "x\u00c4\u00d6\u00dc";
    private static final String ATTRIBUTE_NAME = "attr";
    private static final String ATTRIBUTE_VALUE = "hallo\u00e4\u00f6\u00fc";
    private final String ENCODING_TEST_INPUT = "<?xml version='1.0' %s ?>" + StringUtils.CR + "<" + "x\u00c4\u00d6\u00dc" + " " + "attr" + " ='" + "hallo\u00e4\u00f6\u00fc" + "'/>";
    private final File schema = this.useTestFile("test.xsd");

    public void testInvalidXML() throws IOException {
        File file = this.useTestFile("test01.xml");
        try {
            XMLUtils.parse(file, this.schema);
            XMLUtilsTest.fail((String)"expected exception");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void testValidXML() throws IOException, SAXException {
        File file = this.useTestFile("test02.xml");
        Document document = XMLUtils.parse(file, this.schema);
        XMLUtilsTest.assertEquals((int)21, (int)document.getDocumentElement().getChildNodes().getLength());
    }

    public void testNonWellFormedXML() throws IOException {
        File file = this.useTestFile("test03.xml");
        try {
            XMLUtils.parse(file, this.schema);
            XMLUtilsTest.fail((String)"expected exception");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void testFileInFolderWithSpaces() throws IOException, SAXException {
        File file = this.useTestFile("folder with spaces/test02.xml");
        XMLUtilsTest.assertTrue((boolean)file.exists());
        Document document = XMLUtils.parse(file, this.schema);
        XMLUtilsTest.assertEquals((int)21, (int)document.getDocumentElement().getChildNodes().getLength());
    }

    public void testNonValidating() throws SAXException, IOException {
        File file = this.useTestFile("test01.xml");
        Document document = XMLUtils.parse(file);
        XMLUtilsTest.assertEquals((int)3, (int)document.getDocumentElement().getChildNodes().getLength());
        file = this.useTestFile("test02.xml");
        document = XMLUtils.parse(file);
        XMLUtilsTest.assertEquals((int)21, (int)document.getDocumentElement().getChildNodes().getLength());
        file = this.useTestFile("test03.xml");
        try {
            XMLUtils.parse(file, this.schema);
            XMLUtilsTest.fail((String)"expected exception");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void testEncoding() throws IOException, SAXException {
        this.assertEncodingWorks("UTF-8", "UTF-8");
        this.assertEncodingWorks("UTF-8", null);
        this.assertEncodingWorks("UTF-16", "UTF-16");
        this.assertEncodingWorks("UTF-16", null);
        this.assertEncodingWorks("UTF-16BE", "UTF-16BE");
        this.assertEncodingWorks("UTF-16BE", null);
        this.assertEncodingWorks("UTF-16LE", null);
        this.assertEncodingWorks("ISO-8859-1", "ISO-8859-1");
        this.assertEncodingError("ISO-8859-1", null);
        this.assertEncodingError("UTF-8", "UTF-16");
        this.assertEncodingError("UTF-16", "UTF-8");
    }

    public void assertEncodingWorks(String fileEncoding, String xmlEncoding) throws IOException, SAXException {
        File file = this.writeFile(fileEncoding, xmlEncoding);
        Document doc = XMLUtils.parse(file);
        String encoding = doc.getInputEncoding();
        XMLUtilsTest.assertTrue((encoding.equals("UTF-8") || encoding.equals("UTF-16BE") || encoding.equals("UTF-16LE") ? 1 : 0) != 0);
        XMLUtilsTest.assertEquals((String)ELEMENT_NAME, (String)doc.getDocumentElement().getNodeName());
        XMLUtilsTest.assertEquals((String)ATTRIBUTE_VALUE, (String)doc.getDocumentElement().getAttribute(ATTRIBUTE_NAME));
    }

    public void assertEncodingError(String fileEncoding, String xmlEncoding) {
        try {
            File file = this.writeFile(fileEncoding, xmlEncoding);
            XMLUtils.parse(file);
            XMLUtilsTest.fail();
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File writeFile(String fileEncoding, String xmlEncoding) throws IOException {
        File file = new File(this.getTmpDirectory(), "encoding-test_" + fileEncoding + "_" + xmlEncoding + ".txt");
        FileSystemUtils.writeFile(file, this.createContent(xmlEncoding), fileEncoding);
        return file;
    }

    private String createContent(String xmlEncoding) {
        String encodingSpecifier = "";
        if (xmlEncoding != null) {
            encodingSpecifier = " encoding='" + xmlEncoding + "'";
        }
        return String.format(this.ENCODING_TEST_INPUT, encodingSpecifier);
    }
}

