/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Stack;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.EXMLWriterExceptionType;
import org.conqat.lib.commons.xml.IXMLResolver;
import org.conqat.lib.commons.xml.XMLWriterException;

public class XMLWriter<E extends Enum<E>, A extends Enum<A>> {
    private static final String COMMENT_END = " -->";
    private static final String COMMENT_START = "<!-- ";
    private static final String GT = ">";
    private static final String LT = "<";
    protected final IXMLResolver<E, A> xmlResolver;
    private final HashSet<A> currentAttributes = new HashSet();
    private int currentNestingDepth = -1;
    private final Stack<E> elementStack = new Stack();
    private EState state = EState.DOCUMENT_START;
    private final PrintWriter writer;
    private boolean suppressLineBreaks = false;

    public XMLWriter(OutputStream stream, IXMLResolver<E, A> xmlResolver) {
        try {
            this.writer = new PrintWriter(new OutputStreamWriter(stream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 should always be supported!");
        }
        this.xmlResolver = xmlResolver;
    }

    public XMLWriter(PrintWriter writer, IXMLResolver<E, A> xmlResolver) {
        this.writer = writer;
        this.xmlResolver = xmlResolver;
    }

    public void setSuppressLineBreaks(boolean supressLineBreaks) {
        this.suppressLineBreaks = supressLineBreaks;
    }

    public void addHeader(String version, String encoding) {
        if (this.state != EState.DOCUMENT_START) {
            throw new XMLWriterException("Can be called at the beginning of a document only.", EXMLWriterExceptionType.HEADER_WITHIN_DOCUMENT);
        }
        this.print(LT);
        this.print("?xml version=\"");
        this.print(version);
        this.print("\" encoding=\"");
        this.print(encoding);
        this.print("\"?");
        this.print(GT);
        this.state = EState.OUTSIDE_TAG;
    }

    public void addPublicDocTypeDefintion(E rootElement, String publicId, String systemId) {
        this.print(LT);
        this.print("!DOCTYPE ");
        this.print(this.xmlResolver.resolveElementName(rootElement));
        this.print(" PUBLIC \"");
        this.print(publicId);
        this.print("\" \"");
        this.print(systemId);
        this.print("\"");
        this.print(GT);
        this.state = EState.OUTSIDE_TAG;
    }

    public void openElement(E element) {
        if (this.state == EState.INSIDE_TAG) {
            this.println(GT);
        } else if (this.state == EState.OUTSIDE_TAG) {
            this.println();
        }
        ++this.currentNestingDepth;
        if (this.state != EState.INSIDE_TEXT) {
            this.printIndent();
        }
        this.print(LT);
        this.print(this.xmlResolver.resolveElementName(element));
        this.state = EState.INSIDE_TAG;
        this.elementStack.push(element);
        this.currentAttributes.clear();
    }

    public void addAttribute(A attribute, Object value) {
        if (this.state != EState.INSIDE_TAG) {
            throw new XMLWriterException("Must be called for an open element.", EXMLWriterExceptionType.ATTRIBUTE_OUTSIDE_ELEMENT);
        }
        if (this.currentAttributes.contains(attribute)) {
            throw new XMLWriterException("Duplicate attribute.", EXMLWriterExceptionType.DUPLICATE_ATTRIBUTE);
        }
        this.print(" ");
        this.print(this.xmlResolver.resolveAttributeName(attribute));
        this.print("=");
        this.print("\"");
        this.print(XMLWriter.escape(value.toString()));
        this.print("\"");
        this.currentAttributes.add(attribute);
    }

    public void openElement(E element, Object ... attributes) {
        if (attributes.length % 2 != 0) {
            throw new XMLWriterException("Expected an even number of arguments!", EXMLWriterExceptionType.ODD_NUMBER_OF_ARGUMENTS);
        }
        int i = 0;
        while (i < attributes.length) {
            if (!this.xmlResolver.getAttributeClass().isAssignableFrom(attributes[i].getClass())) {
                throw new XMLWriterException("Attribute name (index " + i + ") must be of type " + this.xmlResolver.getAttributeClass().getName(), EXMLWriterExceptionType.ILLEGAL_ATTRIBUTE_TYPE);
            }
            i += 2;
        }
        this.openElement(element);
        i = 0;
        while (i < attributes.length) {
            Enum a = (Enum)attributes[i];
            this.addAttribute(a, attributes[i + 1]);
            i += 2;
        }
    }

    public void addClosedElement(E element, Object ... attributes) {
        this.openElement(element, attributes);
        this.closeElement(element);
    }

    public void addClosedTextElement(E element, String text, Object ... attributes) {
        this.openElement(element, attributes);
        this.addText(text);
        this.closeElement(element);
    }

    public void closeElement(E element) {
        if (element != this.elementStack.peek()) {
            throw new XMLWriterException("Must close element " + this.elementStack.peek() + " first.", EXMLWriterExceptionType.UNCLOSED_ELEMENT);
        }
        if (this.state == EState.INSIDE_TAG) {
            this.print(" /");
            this.print(GT);
        } else {
            if (this.state != EState.INSIDE_TEXT) {
                this.println();
                this.printIndent();
            }
            this.print(LT);
            this.print("/");
            this.print(this.xmlResolver.resolveElementName(element));
            this.print(GT);
        }
        this.elementStack.pop();
        --this.currentNestingDepth;
        this.state = EState.OUTSIDE_TAG;
    }

    public void addText(String text) {
        if (this.state == EState.INSIDE_TAG) {
            this.print(GT);
        }
        this.print(XMLWriter.escape(text));
        this.state = EState.INSIDE_TEXT;
    }

    public void addCDataSection(String cdata) {
        if (this.state == EState.INSIDE_TAG) {
            this.print(GT);
        }
        if (cdata.contains("]]>")) {
            throw new XMLWriterException("CDATA contains ']]>'", EXMLWriterExceptionType.CDATA_CONTAINS_CDATA_CLOSING_TAG);
        }
        this.print("<![CDATA[");
        this.print(cdata);
        this.print("]]>");
        this.state = EState.INSIDE_TEXT;
    }

    public void addComment(String text) {
        this.ensureOutsideTag();
        ++this.currentNestingDepth;
        this.printIndent();
        this.print(COMMENT_START);
        this.print(XMLWriter.escape(text));
        this.print(COMMENT_END);
        --this.currentNestingDepth;
        this.state = EState.OUTSIDE_TAG;
    }

    public void addNewLine() {
        this.ensureOutsideTag();
    }

    public void close() {
        if (!this.elementStack.isEmpty()) {
            throw new XMLWriterException("Need to close element <" + this.xmlResolver.resolveElementName((Enum)this.elementStack.peek()) + "> before closing writer.", EXMLWriterExceptionType.UNCLOSED_ELEMENT);
        }
        this.writer.close();
    }

    public void flush() {
        this.writer.flush();
    }

    protected void addRawString(String text) {
        if (this.state == EState.INSIDE_TAG) {
            this.print(GT);
        }
        this.print(text);
        this.state = EState.INSIDE_TEXT;
    }

    protected PrintWriter getWriter() {
        return this.writer;
    }

    protected E getCurrentElement() {
        return (E)((Enum)this.elementStack.peek());
    }

    private void ensureOutsideTag() {
        if (this.state == EState.INSIDE_TAG) {
            this.println(GT);
            this.state = EState.OUTSIDE_TAG;
        } else if (this.state == EState.OUTSIDE_TAG) {
            this.println();
        }
    }

    public static String escape(String text) {
        if (text == null) {
            return "";
        }
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll(LT, "&lt;");
        text = text.replaceAll(GT, "&gt;");
        text = text.replaceAll("\"", "&quot;");
        text = StringUtils.replaceLineBreaks(text, StringUtils.CR);
        return text;
    }

    private void print(String message) {
        this.writer.print(message);
    }

    private void printIndent() {
        if (!this.suppressLineBreaks) {
            this.writer.print(StringUtils.fillString(this.currentNestingDepth * 2, ' '));
        }
    }

    private void println() {
        if (!this.suppressLineBreaks) {
            this.print(StringUtils.CR);
        }
    }

    private void println(String text) {
        this.print(text);
        this.println();
    }

    private static enum EState {
        DOCUMENT_START,
        INSIDE_TAG,
        INSIDE_TEXT,
        OUTSIDE_TAG;

    }
}

