/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.xml;

import java.io.ByteArrayOutputStream;
import junit.framework.TestCase;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.EXMLWriterExceptionType;
import org.conqat.lib.commons.xml.XMLResolver;
import org.conqat.lib.commons.xml.XMLWriter;
import org.conqat.lib.commons.xml.XMLWriterException;

public class XMLWriterTest
extends TestCase {
    private ByteArrayOutputStream stream;
    private XMLWriter<Elements, Attributes> writer;

    public void setUp() {
        this.stream = new ByteArrayOutputStream();
        this.writer = new XMLWriter(this.stream, new XMLResolver(Attributes.class));
    }

    public void testAttributeOutsideElement() {
        try {
            this.writer.addAttribute(Attributes.attribute1, "test1");
        }
        catch (XMLWriterException e) {
            XMLWriterTest.assertEquals((Object)((Object)EXMLWriterExceptionType.ATTRIBUTE_OUTSIDE_ELEMENT), (Object)((Object)e.getType()));
        }
    }

    public void testComment() {
        this.writer.addComment("test");
        this.print();
        XMLWriterTest.assertEquals((String)"<!-- test -->", (String)this.normalize());
    }

    public void testCommentBetweenElements() {
        this.writer.openElement(Elements.element1);
        this.writer.closeElement(Elements.element1);
        this.writer.addComment("test");
        this.writer.openElement(Elements.element2);
        this.writer.closeElement(Elements.element2);
        XMLWriterTest.assertEquals((String)"<element1 />\n<!-- test -->\n<element2 />", (String)this.normalize());
    }

    public void testCommentInElement() {
        this.writer.openElement(Elements.element1);
        this.writer.addComment("test");
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1>\n  <!-- test -->\n</element1>", (String)this.normalize());
    }

    public void testNewLineBetweenElements() {
        this.writer.openElement(Elements.element1);
        this.writer.closeElement(Elements.element1);
        this.writer.addNewLine();
        this.writer.openElement(Elements.element2);
        this.writer.closeElement(Elements.element2);
        XMLWriterTest.assertEquals((String)"<element1 />\n\n<element2 />", (String)this.normalize());
    }

    public void testCommentAtBeginningOfDocument() {
        this.writer.addComment("test");
        this.writer.openElement(Elements.element1);
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<!-- test -->\n<element1 />", (String)this.normalize());
    }

    public void testNewLineInElement() {
        this.writer.openElement(Elements.element1);
        this.writer.addNewLine();
        this.writer.openElement(Elements.element2);
        this.writer.closeElement(Elements.element2);
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1>\n\n  <element2 />\n</element1>", (String)this.normalize());
    }

    public void testDuplicateAttribute() {
        this.writer.openElement(Elements.element1);
        this.writer.addAttribute(Attributes.attribute1, "test1");
        try {
            this.writer.addAttribute(Attributes.attribute1, "test1");
        }
        catch (XMLWriterException e) {
            XMLWriterTest.assertEquals((Object)((Object)EXMLWriterExceptionType.DUPLICATE_ATTRIBUTE), (Object)((Object)e.getType()));
        }
    }

    public void testEmptyElement() {
        this.writer.openElement(Elements.element1);
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1 />", (String)this.normalize());
    }

    public void testEscapedTextElement() {
        this.writer.openElement(Elements.element1);
        this.writer.addText("test<test2>test3&test4");
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1>test&lt;test2&gt;test3&amp;test4</element1>", (String)this.normalize());
    }

    public void testMultiLineTextElement() {
        this.writer.openElement(Elements.element1);
        this.writer.addText("test" + StringUtils.CR + "test2");
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1>test\ntest2</element1>", (String)this.normalize());
    }

    public void testNestedComment() {
        this.writer.openElement(Elements.element1);
        this.writer.addComment("test");
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1>\n  <!-- test -->\n</element1>", (String)this.normalize());
    }

    public void testNestedElements() {
        this.writer.openElement(Elements.element1);
        this.writer.openElement(Elements.element2);
        this.writer.closeElement(Elements.element2);
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1>\n  <element2 />\n</element1>", (String)this.normalize());
    }

    public void testNestedElementsWithAttributes() {
        this.writer.openElement(Elements.element1);
        this.writer.addAttribute(Attributes.attribute1, "test1");
        this.writer.openElement(Elements.element2);
        this.writer.addAttribute(Attributes.attribute1, "test1");
        this.writer.closeElement(Elements.element2);
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1 attribute1=\"test1\">\n  <element2 attribute1=\"test1\" />\n</element1>", (String)this.normalize());
    }

    public void testNestedMultiLineTextElement() {
        this.writer.openElement(Elements.element1);
        this.writer.openElement(Elements.element2);
        this.writer.addText("test" + StringUtils.CR + "test2");
        this.writer.closeElement(Elements.element2);
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1>\n  <element2>test\ntest2</element2>\n</element1>", (String)this.normalize());
    }

    public void testNestedSequentialElements() {
        this.writer.openElement(Elements.element1);
        this.writer.openElement(Elements.element2);
        this.writer.closeElement(Elements.element2);
        this.writer.openElement(Elements.element2);
        this.writer.closeElement(Elements.element2);
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1>\n  <element2 />\n  <element2 />\n</element1>", (String)this.normalize());
    }

    public void testNestedTextElement() {
        this.writer.openElement(Elements.element1);
        this.writer.openElement(Elements.element2);
        this.writer.addText("test");
        this.writer.closeElement(Elements.element2);
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1>\n  <element2>test</element2>\n</element1>", (String)this.normalize());
    }

    public void testElementInText() {
        this.writer.openElement(Elements.element1);
        this.writer.addText("test");
        this.writer.openElement(Elements.element2);
        this.writer.addText("test2");
        this.writer.closeElement(Elements.element2);
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1>test<element2>test2</element2>\n</element1>", (String)this.normalize());
    }

    public void testAddHeader() {
        this.writer.addHeader("1.0", "ISO-8859-1");
        this.writer.openElement(Elements.element1);
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<element1 />", (String)this.normalize());
    }

    public void testOneElementWithAttributes() {
        this.writer.openElement(Elements.element1);
        this.writer.addAttribute(Attributes.attribute1, "test1");
        this.writer.addAttribute(Attributes.attribute2, "test2");
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1 attribute1=\"test1\" attribute2=\"test2\" />", (String)this.normalize());
    }

    public void testAttributesWithEscapes() {
        this.writer.openElement(Elements.element1);
        this.writer.addAttribute(Attributes.attribute1, "a&<>\"");
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1 attribute1=\"a&amp;&lt;&gt;&quot;\" />", (String)this.normalize());
    }

    public void testCData() {
        this.writer.openElement(Elements.element1);
        this.writer.addCDataSection("test <element>");
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1><![CDATA[test <element>]]></element1>", (String)this.normalize());
    }

    public void testCDataEscpaing() {
        this.writer.openElement(Elements.element1);
        try {
            this.writer.addCDataSection("test <element> test ]]>");
        }
        catch (XMLWriterException e) {
            XMLWriterTest.assertEquals((Object)((Object)EXMLWriterExceptionType.CDATA_CONTAINS_CDATA_CLOSING_TAG), (Object)((Object)e.getType()));
        }
    }

    public void testCDataWithinText() {
        this.writer.openElement(Elements.element1);
        this.writer.addText("test");
        this.writer.addCDataSection("test <element>");
        this.writer.addText("test");
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1>test<![CDATA[test <element>]]>test</element1>", (String)this.normalize());
    }

    public void testSequentialComment() {
        this.writer.openElement(Elements.element1);
        this.writer.closeElement(Elements.element1);
        this.writer.addComment("test");
        this.writer.openElement(Elements.element2);
        this.writer.closeElement(Elements.element2);
        XMLWriterTest.assertEquals((String)"<element1 />\n<!-- test -->\n<element2 />", (String)this.normalize());
    }

    public void testSequentialElements() {
        this.writer.openElement(Elements.element1);
        this.writer.closeElement(Elements.element1);
        this.writer.openElement(Elements.element2);
        this.writer.closeElement(Elements.element2);
        XMLWriterTest.assertEquals((String)"<element1 />\n<element2 />", (String)this.normalize());
    }

    public void testTextElement() {
        this.writer.openElement(Elements.element1);
        this.writer.addText("test");
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1>test</element1>", (String)this.normalize());
    }

    public void testAddPublicDocTypeDefintion() {
        this.writer.addPublicDocTypeDefintion(Elements.element1, "x", "y");
        XMLWriterTest.assertEquals((String)"<!DOCTYPE element1 PUBLIC \"x\" \"y\">", (String)this.normalize());
    }

    public void testOpenElement() {
        this.writer.openElement(Elements.element1, new Object[]{Attributes.attribute1, "test1", Attributes.attribute2, "test2"});
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1 attribute1=\"test1\" attribute2=\"test2\" />", (String)this.normalize());
    }

    public void testOpenElementWithOddNumberOfAttributes() {
        try {
            this.writer.openElement(Elements.element1, new Object[]{Attributes.attribute1, "test1", Attributes.attribute2});
            XMLWriterTest.fail();
        }
        catch (XMLWriterException e) {
            XMLWriterTest.assertEquals((Object)((Object)EXMLWriterExceptionType.ODD_NUMBER_OF_ARGUMENTS), (Object)((Object)e.getType()));
        }
    }

    public void testOpenElementWithIllegalAttribute() {
        try {
            this.writer.openElement(Elements.element1, new Object[]{Attributes.attribute1, "test1", new Integer(5), "test2"});
            XMLWriterTest.fail();
        }
        catch (XMLWriterException e) {
            XMLWriterTest.assertEquals((Object)((Object)EXMLWriterExceptionType.ILLEGAL_ATTRIBUTE_TYPE), (Object)((Object)e.getType()));
        }
    }

    public void testUnclosedElement() {
        this.writer.openElement(Elements.element1);
        try {
            this.writer.closeElement(Elements.element2);
            XMLWriterTest.fail();
        }
        catch (XMLWriterException e) {
            XMLWriterTest.assertEquals((Object)((Object)EXMLWriterExceptionType.UNCLOSED_ELEMENT), (Object)((Object)e.getType()));
        }
    }

    public void testRemainingOpenElementWhenClosingWriter() {
        this.writer.openElement(Elements.element1);
        try {
            this.writer.close();
            XMLWriterTest.fail();
        }
        catch (XMLWriterException e) {
            XMLWriterTest.assertEquals((Object)((Object)EXMLWriterExceptionType.UNCLOSED_ELEMENT), (Object)((Object)e.getType()));
        }
    }

    public void testSuppressLineBreaks() {
        this.writer.setSuppressLineBreaks(true);
        this.writer.openElement(Elements.element1);
        this.writer.closeElement(Elements.element1);
        this.writer.openElement(Elements.element2);
        this.writer.closeElement(Elements.element2);
        this.writer.openElement(Elements.element1);
        this.writer.addText("test");
        this.writer.openElement(Elements.element2);
        this.writer.addText("test2");
        this.writer.closeElement(Elements.element2);
        this.writer.closeElement(Elements.element1);
        XMLWriterTest.assertEquals((String)"<element1 /><element2 /><element1>test<element2>test2</element2></element1>", (String)this.normalize());
    }

    public void testSuppressLineBreaks2() {
        this.writer.setSuppressLineBreaks(true);
    }

    private String createTestString() {
        String string = this.stream.toString();
        string = StringUtils.replaceLineBreaks(string);
        string = string.replace("\"", "\\\"");
        return string;
    }

    private String normalize() {
        this.writer.flush();
        String string = this.stream.toString();
        string = StringUtils.replaceLineBreaks(string, "\n");
        return string;
    }

    private void print() {
        this.writer.flush();
        System.out.println(this.stream);
        System.out.println(this.createTestString());
    }

    private static enum Attributes {
        attribute1,
        attribute2;

    }

    private static enum Elements {
        element1,
        element2;

    }
}

