/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.xml.example;

import java.io.File;
import java.io.IOException;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.xml.IXMLElementProcessor;
import org.conqat.lib.commons.xml.XMLReader;
import org.conqat.lib.commons.xml.example.Address;
import org.conqat.lib.commons.xml.example.EXMLAttribute;
import org.conqat.lib.commons.xml.example.EXMLElement;
import org.conqat.lib.commons.xml.example.Model;
import org.conqat.lib.commons.xml.example.ModelPersistenceException;
import org.conqat.lib.commons.xml.example.ModelResolver;
import org.conqat.lib.commons.xml.example.Order;
import org.conqat.lib.commons.xml.example.Person;
import org.xml.sax.SAXException;

public class ModelReader
extends XMLReader<EXMLElement, EXMLAttribute, ModelPersistenceException> {
    private final Model model;

    public ModelReader(File file, Model model) throws IOException {
        super(file, new ModelResolver());
        this.model = model;
    }

    public void readModel() throws ModelPersistenceException {
        this.model.clear();
        this.parseModel();
        this.processChildElements(new PersonProcessor());
    }

    private void parseModel() throws ModelPersistenceException {
        try {
            this.parseFile();
        }
        catch (SAXException e) {
            throw new ModelPersistenceException("Parsing Error");
        }
        catch (IOException e) {
            throw new ModelPersistenceException("IO Error");
        }
    }

    private class AddressProcessor
    implements IXMLElementProcessor<EXMLElement, ModelPersistenceException> {
        private Address address;

        private AddressProcessor() {
        }

        @Override
        public EXMLElement getTargetElement() {
            return EXMLElement.ADDRESS;
        }

        @Override
        public void process() throws NeverThrownRuntimeException {
            String street = ModelReader.this.getChildText(EXMLElement.STREET);
            String city = ModelReader.this.getChildText(EXMLElement.CITY);
            this.address = new Address(street, city);
        }
    }

    private class OrderProcessor
    implements IXMLElementProcessor<EXMLElement, ModelPersistenceException> {
        private final Person person;

        public OrderProcessor(Person person) {
            this.person = person;
        }

        @Override
        public EXMLElement getTargetElement() {
            return EXMLElement.ORDER;
        }

        @Override
        public void process() throws ModelPersistenceException {
            if (this.person.getOrderCount() >= 2) {
                throw new ModelPersistenceException("Too many orders");
            }
            String orderNumber = ModelReader.this.getStringAttribute(EXMLAttribute.ARTICLE_NUMBER);
            String description = ModelReader.this.getText();
            Order order = new Order(description, orderNumber);
            this.person.add(order);
        }
    }

    private class OrdersProcessor
    implements IXMLElementProcessor<EXMLElement, ModelPersistenceException> {
        private final Person person;

        public OrdersProcessor(Person person) {
            this.person = person;
        }

        @Override
        public EXMLElement getTargetElement() {
            return EXMLElement.ORDERS;
        }

        @Override
        public void process() throws ModelPersistenceException {
            ModelReader.this.processChildElements(new OrderProcessor(this.person));
        }
    }

    private class PersonProcessor
    implements IXMLElementProcessor<EXMLElement, ModelPersistenceException> {
        private PersonProcessor() {
        }

        @Override
        public EXMLElement getTargetElement() {
            return EXMLElement.PERSON;
        }

        @Override
        public void process() throws ModelPersistenceException {
            String name = ModelReader.this.getChildText(EXMLElement.NAME);
            String details = ModelReader.this.getChildText(EXMLElement.DETAILS);
            AddressProcessor addressProcessor = new AddressProcessor();
            ModelReader.this.processChildElements(addressProcessor);
            Person person = new Person(name, addressProcessor.address, details);
            ModelReader.this.processChildElements(new OrdersProcessor(person));
            ModelReader.this.model.add(person);
        }
    }
}

