/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.xml.example;

import java.io.File;
import java.io.IOException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.xml.example.Address;
import org.conqat.lib.commons.xml.example.Model;
import org.conqat.lib.commons.xml.example.ModelWriter;
import org.conqat.lib.commons.xml.example.Order;
import org.conqat.lib.commons.xml.example.Person;

public class ModelUtils {
    public static Model createExampleModel() {
        Model model = new Model();
        Address addressA = new Address("Street A", "City A");
        Address addressB = new Address("Street B", "City B");
        Person personA = new Person("Person A", addressA, "details of person A");
        Person personB = new Person("Person B", addressB, "details of person B contain Markup: <element/> &<>'\"");
        Order order1 = new Order("Order 1", "1");
        Order order2 = new Order("Order 2", "2");
        Order order3 = new Order("Order 3", "3");
        Order order4 = new Order("Order 4", "4&<>'\"");
        personA.add(order1);
        personA.add(order2);
        personB.add(order3);
        personB.add(order4);
        model.add(personA);
        model.add(personB);
        return model;
    }

    public static Model createIllegalExampleModel() {
        Model model = ModelUtils.createExampleModel();
        Address address = new Address("Illegal Street", "Illegal City");
        Person person = new Person("Illegal Person", address, "Illegal Details");
        Order order1 = new Order("Order 1", "1");
        Order order2 = new Order("Order 2", "2");
        Order order3 = new Order("Order 3", "3");
        person.add(order1);
        person.add(order2);
        person.add(order3);
        model.add(person);
        return model;
    }

    public static void writeModel(Model model, File file) throws IOException {
        FileSystemUtils.ensureParentDirectoryExists(file);
        ModelWriter writer = new ModelWriter(file, model);
        writer.writeModel();
    }
}

