/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.xml.example;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import org.conqat.lib.commons.xml.XMLWriter;
import org.conqat.lib.commons.xml.example.Address;
import org.conqat.lib.commons.xml.example.EXMLAttribute;
import org.conqat.lib.commons.xml.example.EXMLElement;
import org.conqat.lib.commons.xml.example.Model;
import org.conqat.lib.commons.xml.example.ModelResolver;
import org.conqat.lib.commons.xml.example.Order;
import org.conqat.lib.commons.xml.example.Person;

public class ModelWriter
extends XMLWriter<EXMLElement, EXMLAttribute> {
    private final Model model;

    public ModelWriter(File file, Model model) throws FileNotFoundException {
        super(new PrintStream(file), new ModelResolver());
        this.model = model;
    }

    public void writeModel() {
        this.addHeader("1.0", "ISO-8859-1");
        this.openElement(EXMLElement.MODEL);
        for (Person person : this.model.getPersons()) {
            this.write(person);
        }
        this.closeElement(EXMLElement.MODEL);
        this.close();
    }

    private void write(Address address) {
        this.openElement(EXMLElement.ADDRESS);
        this.openElement(EXMLElement.STREET);
        this.addText(address.getStreet());
        this.closeElement(EXMLElement.STREET);
        this.openElement(EXMLElement.CITY);
        this.addText(address.getCity());
        this.closeElement(EXMLElement.CITY);
        this.closeElement(EXMLElement.ADDRESS);
    }

    private void write(Order order) {
        this.openElement(EXMLElement.ORDER);
        this.addAttribute(EXMLAttribute.ARTICLE_NUMBER, order.getArticleNumber());
        this.addText(order.getDescription());
        this.closeElement(EXMLElement.ORDER);
    }

    private void write(Person person) {
        this.openElement(EXMLElement.PERSON);
        this.openElement(EXMLElement.NAME);
        this.addText(person.getName());
        this.closeElement(EXMLElement.NAME);
        this.write(person.getAddress());
        this.openElement(EXMLElement.DETAILS);
        this.addCDataSection(person.getDetails());
        this.closeElement(EXMLElement.DETAILS);
        this.openElement(EXMLElement.ORDERS);
        for (Order order : person.getOrders()) {
            this.write(order);
        }
        this.closeElement(EXMLElement.ORDERS);
        this.closeElement(EXMLElement.PERSON);
    }
}

