/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.xml.example;

import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.xml.example.Address;
import org.conqat.lib.commons.xml.example.Order;

public class Person {
    private final String name;
    private final Address address;
    private final ArrayList<Order> orders = new ArrayList();
    private final String details;

    public Person(String name, Address address, String details) {
        this.name = name;
        this.address = address;
        this.details = details;
    }

    public void add(Order order) {
        this.orders.add(order);
    }

    public Address getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public int getOrderCount() {
        return this.orders.size();
    }

    public String getDetails() {
        return this.details;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Person)) {
            return false;
        }
        Person otherPerson = (Person)other;
        if (!this.name.equals(otherPerson.name)) {
            return false;
        }
        if (!this.address.equals(otherPerson.address)) {
            return false;
        }
        if (!this.details.equals(otherPerson.details)) {
            return false;
        }
        if (this.orders.size() != otherPerson.orders.size()) {
            return false;
        }
        int i = 0;
        while (i < this.orders.size()) {
            if (!this.orders.get(i).equals(otherPerson.orders.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return 13;
    }
}

