/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ScannerTestBase;

public class ABAPScannerTest
extends ScannerTestBase {
    protected ELanguage getLanguage() {
        return ELanguage.ABAP;
    }

    public void testErrorCases() throws IOException {
        this.checkCharLiteralErrorCases();
        this.checkStringLiteralErrorCases();
    }

    private void checkCharLiteralErrorCases() throws IOException {
        this.assertTokens("'ua", ETokenType.UNTERMINATED_CHARACTER_LITERAL, ETokenType.EOF);
    }

    private void checkStringLiteralErrorCases() throws IOException {
        this.assertTokens("`unclosed literal", ETokenType.UNTERMINATED_STRING_LITERAL, ETokenType.EOF);
    }

    public void testWhitespace() throws IOException {
        this.assertTokens(" ", new ETokenType[0]);
        this.assertTokens("\r\n", new ETokenType[0]);
        this.assertTokens(" \r\n", new ETokenType[0]);
    }

    public void testComments() throws IOException {
        this.assertToken("* This is a tranditional comment", ETokenType.TRADITIONAL_COMMENT);
        this.assertToken("*", ETokenType.TRADITIONAL_COMMENT);
        this.assertTokens("* This is a traditional\n* two line comment.", ETokenType.TRADITIONAL_COMMENT, ETokenType.TRADITIONAL_COMMENT);
        this.assertToken("\" This is an end of line comment.", ETokenType.END_OF_LINE_COMMENT);
        this.assertTokens("CLASS \" This is an end of line comment.", ETokenType.CLASS, ETokenType.END_OF_LINE_COMMENT);
    }

    public void testKeywords() throws IOException {
        this.assertToken("CLASS", ETokenType.CLASS);
        this.assertTokens("DATA:", ETokenType.DATA, ETokenType.COLON);
    }

    public void testOperators() throws IOException {
        this.assertToken("&", ETokenType.LITERAL_OPERATOR);
        this.assertTokens("'first' & 'second'", ETokenType.CHARACTER_LITERAL, ETokenType.LITERAL_OPERATOR, ETokenType.CHARACTER_LITERAL);
        this.assertTokens("a~bcde", ETokenType.IDENTIFIER, ETokenType.TILDE, ETokenType.IDENTIFIER);
        this.assertTokens("1 * 2", ETokenType.INTEGER_LITERAL, ETokenType.MULT, ETokenType.INTEGER_LITERAL);
    }

    public void testIdentifiers() throws IOException {
        this.assertToken("a_bc_defghi_j", ETokenType.IDENTIFIER);
        this.assertToken("%rec", ETokenType.IDENTIFIER);
        this.assertToken("rec%", ETokenType.IDENTIFIER);
        this.assertToken("rec\u00df", ETokenType.IDENTIFIER);
        this.assertToken("\u00dfrec", ETokenType.IDENTIFIER);
        this.assertToken("rec?", ETokenType.IDENTIFIER);
        this.assertToken("?rec", ETokenType.IDENTIFIER);
        this.assertToken("\u2030\u00b8\u02c6\u0192\u00f7\u2039", ETokenType.IDENTIFIER);
        this.assertToken("\u00b8\u2030\u02c6\u0192\u00f7\u2039", ETokenType.IDENTIFIER);
        this.assertToken("\u02c6\u00b8\u2030\u0192\u00f7\u2039", ETokenType.IDENTIFIER);
        this.assertToken("\u0192\u00f7\u2039\u2030\u00b8\u02c6", ETokenType.IDENTIFIER);
        this.assertToken("\u00f7\u2039\u0192\u2030\u00b8\u02c6", ETokenType.IDENTIFIER);
        this.assertToken("\u2039\u0192\u00f7\u2030\u00b8\u02c6", ETokenType.IDENTIFIER);
        this.assertToken("&6", ETokenType.PLACEHOLDER);
    }

    public void testLiterals() throws IOException {
        this.assertTokens("'SY-TITLE:', SY-TITLE(30), ',', 'TRANSFER v1 also works            '.", ETokenType.CHARACTER_LITERAL, ETokenType.COMMA, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.INTEGER_LITERAL, ETokenType.RPAREN, ETokenType.COMMA, ETokenType.CHARACTER_LITERAL, ETokenType.COMMA, ETokenType.CHARACTER_LITERAL, ETokenType.DOT);
        this.assertToken("'Creation of an internal table with ''APPEND itab ''      '", ETokenType.CHARACTER_LITERAL);
        this.assertToken("`A backquote (``)`", ETokenType.STRING_LITERAL);
        this.assertToken("'test\ntest'", ETokenType.CHARACTER_LITERAL);
    }

    public void testCommentContent() {
        this.assertCommentContent("test", " * test");
        this.assertCommentContent(this.concat("test", "test"), this.concat(" *test", "*test"));
        this.assertCommentContent("test", "    \"   test    ");
    }

    private void assertCommentContent(String expectedContent, String comment) {
        String content = this.getLanguage().getCommentContent(comment);
        CCSMAssert.isTrue(content.equals(expectedContent), "The content extracted from the content does not match the expected content.");
    }

    private String concat(String ... lines) {
        return StringUtils.concat((Object[])lines, StringUtils.CR);
    }
}

