/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.IToken;
import org.conqat.lib.scanner.ScannerTestBase;

public class CPPScannerTest
extends ScannerTestBase {
    protected ELanguage getLanguage() {
        return ELanguage.CPP;
    }

    public void testErrorCases() throws IOException {
        this.checkCharLiteralErrorCases();
        this.checkStringLiteralErrorCases();
        this.chechBackTickStringLiteralErrorCases();
    }

    private void checkCharLiteralErrorCases() throws IOException {
        this.assertTokens("'ua\n identifier", ETokenType.UNTERMINATED_CHARACTER_LITERAL, ETokenType.IDENTIFIER);
        this.assertTokens("'ua", ETokenType.UNTERMINATED_CHARACTER_LITERAL, ETokenType.EOF);
    }

    private void checkStringLiteralErrorCases() throws IOException {
        this.assertTokens("\"unclosed literal\nidentifier", ETokenType.UNTERMINATED_STRING_LITERAL, ETokenType.IDENTIFIER);
        this.assertTokens("\"unclosed literal", ETokenType.UNTERMINATED_STRING_LITERAL, ETokenType.EOF);
    }

    private void chechBackTickStringLiteralErrorCases() throws IOException {
        this.assertTokens("`unclosed literal\nidentifier", ETokenType.UNTERMINATED_STRING_LITERAL, ETokenType.IDENTIFIER);
        this.assertTokens("`unclosed literal", ETokenType.UNTERMINATED_STRING_LITERAL, ETokenType.EOF);
    }

    public void testCr2551() throws IOException {
        this.assertTokens("#if 0 /* a #endif a's */ #endif", ETokenType.IF_ZERO_BLOCK, ETokenType.EOF);
    }

    public void testUsualCharLiteral() throws IOException {
        this.assertToken("'a'", ETokenType.CHARACTER_LITERAL);
    }

    public void testIntegerLiteral() throws IOException {
        this.assertToken("0", ETokenType.INTEGER_LITERAL);
        this.assertToken("1", ETokenType.INTEGER_LITERAL);
        this.assertToken("123", ETokenType.INTEGER_LITERAL);
    }

    public void testHexIntegerLiteral() throws IOException {
        this.assertToken("0xA", ETokenType.INTEGER_LITERAL);
    }

    public void testOctalIntegerLiteral() throws IOException {
        this.assertToken("023", ETokenType.INTEGER_LITERAL);
    }

    public void testLongIntegerLiteral() throws IOException {
        this.assertToken("0l", ETokenType.INTEGER_LITERAL);
        this.assertToken("1l", ETokenType.INTEGER_LITERAL);
        this.assertToken("123l", ETokenType.INTEGER_LITERAL);
        this.assertToken("123L", ETokenType.INTEGER_LITERAL);
    }

    public void testLongHexIntegerLiteral() throws IOException {
        this.assertToken("0xAl", ETokenType.INTEGER_LITERAL);
    }

    public void testLongOctalIntegerLiteral() throws IOException {
        this.assertToken("023l", ETokenType.INTEGER_LITERAL);
    }

    public void testFloatLiteral() throws IOException {
        this.assertToken("0.0f", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("0.5f", ETokenType.FLOATING_POINT_LITERAL);
    }

    public void testDoubleLiteral() throws IOException {
        this.assertToken("0.5", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("0.5", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("0.5d", ETokenType.FLOATING_POINT_LITERAL);
    }

    public void testBoolLiteral() throws IOException {
        this.assertToken("true", ETokenType.BOOLEAN_LITERAL);
        this.assertToken("false", ETokenType.BOOLEAN_LITERAL);
    }

    public void testSimpleStringLiteral() throws IOException {
        this.assertToken("\"test\"", ETokenType.STRING_LITERAL);
    }

    public void testMultiLineStringLiteral() throws IOException {
        this.assertToken("\"test \\\n test\"", ETokenType.STRING_LITERAL);
        this.assertTokens("\"test \\\n test\" identifier", ETokenType.STRING_LITERAL, ETokenType.IDENTIFIER, ETokenType.EOF);
    }

    public void testEscapedStringLiteral() throws IOException {
        this.assertToken("\"test \\t test2\"", ETokenType.STRING_LITERAL);
        this.assertToken("\"test \\101 test2\"", ETokenType.STRING_LITERAL);
        this.assertToken("\"test \\101 test2 \\102 \\n\"", ETokenType.STRING_LITERAL);
    }

    public void testBacktickStringLiteral() throws IOException {
        this.assertToken("`test test2`", ETokenType.BACKTICK_STRING_LITERAL);
    }

    public void testComments() throws IOException {
        this.assertToken("// test", ETokenType.END_OF_LINE_COMMENT);
        this.assertToken("# // test", ETokenType.END_OF_LINE_COMMENT);
        this.assertToken("/* test\n test */", ETokenType.TRADITIONAL_COMMENT);
        this.assertToken("# /* test\n# test */", ETokenType.TRADITIONAL_COMMENT);
        this.assertToken("/** test\n test */", ETokenType.DOCUMENTATION_COMMENT);
    }

    public void testPreprocessorDirectives() throws IOException {
        this.assertToken("#include", ETokenType.PREPROCESSOR_DIRECTIVE);
        this.assertToken("# include", ETokenType.PREPROCESSOR_DIRECTIVE);
    }

    public void testSingleHash() throws IOException {
        this.assertTokens("a\n#  \nb", ETokenType.IDENTIFIER, ETokenType.IDENTIFIER);
    }

    public void testIf0Block() throws IOException {
        this.assertToken("#if 0 this is a test #endif", ETokenType.IF_ZERO_BLOCK);
        this.assertToken("#if 0 this \n is a test #endif", ETokenType.IF_ZERO_BLOCK);
    }

    public void testErrorDirective() throws IOException {
        this.assertToken("#error Unimplemented EBCDIC platform. Please send information about your system to <martin@apache.org>!\n", ETokenType.PREPROCESSOR_DIRECTIVE);
        this.assertToken("#error Unimplemented EBCDIC platform. Please send information about your system to <martin@apache.org>!\r\n", ETokenType.PREPROCESSOR_DIRECTIVE);
        this.assertToken("#error Unimplemented EBCDIC platform. Please send information about your system to <martin@apache.org>!\r", ETokenType.PREPROCESSOR_DIRECTIVE);
        this.assertTokens("#error Unimplemented EBCDIC platform. Please send information about your system to <martin@apache.org>!\ntest", ETokenType.PREPROCESSOR_DIRECTIVE, ETokenType.IDENTIFIER);
    }

    public void testIllegalUnterminatedStringLiteral() throws IOException {
        String testString = "\"test\ntest2";
        CPPScannerTest.assertTrue((boolean)this.findProblem(testString));
    }

    public void testIllegalUnterminatedStringLiteral2() throws IOException {
        String testString = "test\"\ntest2";
        CPPScannerTest.assertTrue((boolean)this.findProblem(testString));
    }

    public void testIllegalUnterminatedCharLiteral() throws IOException {
        String testString = "'\ntest2";
        CPPScannerTest.assertTrue((boolean)this.findProblem(testString));
    }

    public void testCommentHasNoLeadingWhitespace() throws IOException {
        String text = "This is a comment";
        String tradCommentText = "/* " + text + " */";
        String eolCommentText = "// " + text;
        IToken traditionalCommentToken = this.firstTokenFor("\r\n\r\n" + tradCommentText);
        CPPScannerTest.assertEquals((String)tradCommentText, (String)traditionalCommentToken.getText());
        IToken eolCommentToken = this.firstTokenFor("   " + eolCommentText);
        CPPScannerTest.assertEquals((String)eolCommentText, (String)eolCommentToken.getText());
    }
}

