/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ILenientScanner;
import org.conqat.lib.scanner.IToken;
import org.conqat.lib.scanner.ScannerTestBase;

public class CsScannerTest
extends ScannerTestBase {
    protected ELanguage getLanguage() {
        return ELanguage.CS;
    }

    public void testErrorCases() throws IOException {
        this.checkCharLiteralErrorCases();
        this.checkStringLiteralErrorCases();
        this.checkMultiLineStringLiteralErrorCase();
    }

    private void checkCharLiteralErrorCases() throws IOException {
        this.assertTokens("'ua" + StringUtils.CR + " identifier", ETokenType.UNTERMINATED_CHARACTER_LITERAL, ETokenType.IDENTIFIER);
        this.assertTokens("'ua", ETokenType.UNTERMINATED_CHARACTER_LITERAL, ETokenType.EOF);
        this.assertTokens("'test\\ktest' identifier", ETokenType.ILLEGAL_ESCAPE_SEQUENCE, ETokenType.CHARACTER_LITERAL, ETokenType.IDENTIFIER);
    }

    private void checkStringLiteralErrorCases() throws IOException {
        this.assertTokens("\"unclosed literal" + StringUtils.CR + "identifier", ETokenType.UNTERMINATED_STRING_LITERAL, ETokenType.IDENTIFIER);
        this.assertTokens("\"unclosed literal", ETokenType.UNTERMINATED_STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("\"test\\ktest\" identifier", ETokenType.ILLEGAL_ESCAPE_SEQUENCE, ETokenType.STRING_LITERAL, ETokenType.IDENTIFIER);
    }

    private void checkMultiLineStringLiteralErrorCase() throws IOException {
        this.assertTokens("@\"multi" + StringUtils.CR + "line" + StringUtils.CR, ETokenType.UNTERMINATED_STRING_LITERAL, ETokenType.EOF);
    }

    public void testUsualCharLiteral() throws IOException {
        this.assertToken("'a'", ETokenType.CHARACTER_LITERAL);
    }

    public void testEscapedCharLiteral() throws IOException {
        this.assertToken("'\\''", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'\\\"'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'\\\\'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'\\a'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'\\b'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'\\f'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'\\n'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'\\r'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'\\t'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'\\u'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'\\u000d'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'\\U'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'\\v'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'\\x08b'", ETokenType.CHARACTER_LITERAL);
        this.assertToken("'\\x08bf'", ETokenType.CHARACTER_LITERAL);
    }

    public void testIntegerLiteral() throws IOException {
        this.assertToken("0", ETokenType.INTEGER_LITERAL);
        this.assertToken("1", ETokenType.INTEGER_LITERAL);
        this.assertToken("123", ETokenType.INTEGER_LITERAL);
    }

    public void testHexIntegerLiteral() throws IOException {
        this.assertToken("0xA", ETokenType.INTEGER_LITERAL);
    }

    public void testOctalIntegerLiteral() throws IOException {
        this.assertToken("023", ETokenType.INTEGER_LITERAL);
    }

    public void testLongIntegerLiteral() throws IOException {
        this.assertToken("0l", ETokenType.INTEGER_LITERAL);
        this.assertToken("1l", ETokenType.INTEGER_LITERAL);
        this.assertToken("123l", ETokenType.INTEGER_LITERAL);
        this.assertToken("123L", ETokenType.INTEGER_LITERAL);
    }

    public void testLongHexIntegerLiteral() throws IOException {
        this.assertToken("0xAl", ETokenType.INTEGER_LITERAL);
    }

    public void testLongOctalIntegerLiteral() throws IOException {
        this.assertToken("023l", ETokenType.INTEGER_LITERAL);
    }

    public void testFloatLiteral() throws IOException {
        this.assertToken("0.0f", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("0.5f", ETokenType.FLOATING_POINT_LITERAL);
    }

    public void testDoubleLiteral() throws IOException {
        this.assertToken("0.5", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("0.5", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("0.5d", ETokenType.FLOATING_POINT_LITERAL);
    }

    public void testBoolLiteral() throws IOException {
        this.assertToken("true", ETokenType.BOOLEAN_LITERAL);
        this.assertToken("false", ETokenType.BOOLEAN_LITERAL);
    }

    public void testSimpleStringLiteral() throws IOException {
        this.assertToken("\"test\"", ETokenType.STRING_LITERAL);
    }

    public void testSimpleMultilineString() throws Exception {
        this.assertToken("@\"\\\"", ETokenType.STRING_LITERAL);
        this.assertToken("@\"start\"\"end \"", ETokenType.STRING_LITERAL);
    }

    public void testMultiLineStringLiteral() throws Exception {
        this.assertToken("@\"test " + StringUtils.CR + " newline\"", ETokenType.STRING_LITERAL);
    }

    public void testSlashedMultilineStringLiteral() throws Exception {
        this.assertToken("@\"$(SharpDevelopBinPath)\\SharpDevelop.Build.CSharp.targets\"", ETokenType.STRING_LITERAL);
    }

    public void testEscapedStringLiteral() throws IOException {
        this.assertToken("\"test \\t test2\"", ETokenType.STRING_LITERAL);
        this.assertToken("\"test \\x101 test2\"", ETokenType.STRING_LITERAL);
        this.assertToken("\"test \\x101 test2 \\x102 \\n\"", ETokenType.STRING_LITERAL);
    }

    public void testComments() throws IOException {
        this.assertToken("// test", ETokenType.END_OF_LINE_COMMENT);
        this.assertToken("/* test" + StringUtils.CR + " test */", ETokenType.TRADITIONAL_COMMENT);
        this.assertToken("/// test" + StringUtils.CR + "  /// test ", ETokenType.DOCUMENTATION_COMMENT);
    }

    public void testIllegalEscapeSequence() throws IOException {
        String testString = "\"test \\o\"";
        CsScannerTest.assertTrue((boolean)this.findProblem(testString));
    }

    public void testRegion() throws Exception {
        this.assertToken("#region", ETokenType.PREPROCESSOR_DIRECTIVE);
        this.assertToken("#region RegionName", ETokenType.PREPROCESSOR_DIRECTIVE);
        this.assertToken("#region Some other Region Name", ETokenType.PREPROCESSOR_DIRECTIVE);
        this.assertTokens("#region Start" + StringUtils.CR + " // Some comment " + StringUtils.CR + " #endregion", ETokenType.PREPROCESSOR_DIRECTIVE, ETokenType.END_OF_LINE_COMMENT, ETokenType.PREPROCESSOR_DIRECTIVE);
    }

    public void testIllegalCharacterBackslash() throws IOException {
        String testString = "test \\o";
        CsScannerTest.assertTrue((boolean)this.findProblem(testString));
    }

    public void testIdentifier() throws Exception {
        this.assertToken("MyName", ETokenType.IDENTIFIER);
        this.assertToken("@void", ETokenType.IDENTIFIER);
    }

    public void testIllegalUnterminatedStringLiteral() throws IOException {
        String testString = "\"test" + StringUtils.CR + "test2";
        CsScannerTest.assertTrue((boolean)this.findProblem(testString));
    }

    public void testIllegalUnterminatedStringLiteral2() throws IOException {
        String testString = "test\"" + StringUtils.CR + "test2";
        CsScannerTest.assertTrue((boolean)this.findProblem(testString));
    }

    public void testIllegalUnterminatedCharLiteral() throws IOException {
        String testString = "'" + StringUtils.CR + "test2";
        CsScannerTest.assertTrue((boolean)this.findProblem(testString));
    }

    public void testVerbatimStringLiteralWithPseudoUnicodeEspace() throws Exception {
        this.assertToken("@\"\\uc1\"", ETokenType.STRING_LITERAL);
    }

    public void testCustomAttribute() throws Exception {
        this.assertTokens("[CustomAttribute]", ETokenType.LBRACK, ETokenType.IDENTIFIER, ETokenType.RBRACK);
    }

    public void testYYCharIdentifier() throws Exception {
        ILenientScanner scanner = this.getScannerFor("Identifier");
        IToken literalToken = scanner.getNextToken();
        this.assertTokenOffset(literalToken, ETokenType.IDENTIFIER, 0);
    }

    public void testYYCharStringLiteral() throws Exception {
        ILenientScanner scanner = this.getScannerFor("\"Stringliteral1\" \"Stringliteral2\" Identifier");
        IToken literalToken1 = scanner.getNextToken();
        this.assertTokenOffset(literalToken1, ETokenType.STRING_LITERAL, 0);
        IToken literalToken2 = scanner.getNextToken();
        this.assertTokenOffset(literalToken2, ETokenType.STRING_LITERAL, 17);
        IToken identifierToken = scanner.getNextToken();
        this.assertTokenOffset(identifierToken, ETokenType.IDENTIFIER, 34);
    }

    public void testYYCharVerbatimStringLiteral() throws Exception {
        ILenientScanner scanner = this.getScannerFor("@\"Stringliteral1\" @\"Stringliteral2\" Identifier");
        IToken literalToken1 = scanner.getNextToken();
        this.assertTokenOffset(literalToken1, ETokenType.STRING_LITERAL, 0);
        IToken literalToken2 = scanner.getNextToken();
        this.assertTokenOffset(literalToken2, ETokenType.STRING_LITERAL, 18);
        IToken identifierToken = scanner.getNextToken();
        this.assertTokenOffset(identifierToken, ETokenType.IDENTIFIER, 36);
    }

    public void testYYCharCharLiteral() throws Exception {
        ILenientScanner scanner = this.getScannerFor("'a' Identifier 'b' '\\'' 'd'");
        IToken literalToken1 = scanner.getNextToken();
        this.assertTokenOffset(literalToken1, ETokenType.CHARACTER_LITERAL, 0);
        IToken identifierToken = scanner.getNextToken();
        this.assertTokenOffset(identifierToken, ETokenType.IDENTIFIER, 4);
        IToken literalToken2 = scanner.getNextToken();
        this.assertTokenOffset(literalToken2, ETokenType.CHARACTER_LITERAL, 15);
        IToken literalToken3 = scanner.getNextToken();
        this.assertTokenOffset(literalToken3, ETokenType.CHARACTER_LITERAL, 19);
        IToken literalToken4 = scanner.getNextToken();
        this.assertTokenOffset(literalToken4, ETokenType.CHARACTER_LITERAL, 24);
    }
}

