/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.EnumSet;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ILenientScanner;
import org.conqat.lib.scanner.MatlabToken;

class MatlabScanner
implements ILenientScanner {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int STRING = 2;
    public static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1};
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\f\u0001\u0002\u0001\u0000\u0001\r\u0001\u0001\u0012\u0000\u0001\f\u0004\u0000\u0001\u000b\u0001+\u0001\u000e\u0001.\u0001/\u0001\"\u0001!\u00014\u0001\u0004\u0001\u0006\u0001#\n\u0003\u0001%\u00015\u0001'\u0001(\u0001)\u0001\u0000\u0001\b\u0003\t\u0002\u0005\u0015\t\u00010\u0001$\u00011\u0001&\u0001\n\u0001\u0000\u0001\u001a\u0001\u0019\u0001\u001e\u0001\u0014\u0001\u0012\u0001\u000f\u0001\u0018\u0001\u001c\u0001\u0015\u0001\u0007\u0001\t\u0001\u0016\u0001\t\u0001\u0013\u0001\u0010\u0002\t\u0001\u0011\u0001\u0017\u0001\u001f\u0001\u001d\u0001\t\u0001\u001b\u0001-\u0001 \u0001\t\u00012\u0001,\u00013\u0001*\uff81\u0000";
    private static final char[] ZZ_CMAP = MatlabScanner.zzUnpackCMap("\t\u0000\u0001\f\u0001\u0002\u0001\u0000\u0001\r\u0001\u0001\u0012\u0000\u0001\f\u0004\u0000\u0001\u000b\u0001+\u0001\u000e\u0001.\u0001/\u0001\"\u0001!\u00014\u0001\u0004\u0001\u0006\u0001#\n\u0003\u0001%\u00015\u0001'\u0001(\u0001)\u0001\u0000\u0001\b\u0003\t\u0002\u0005\u0015\t\u00010\u0001$\u00011\u0001&\u0001\n\u0001\u0000\u0001\u001a\u0001\u0019\u0001\u001e\u0001\u0014\u0001\u0012\u0001\u000f\u0001\u0018\u0001\u001c\u0001\u0015\u0001\u0007\u0001\t\u0001\u0016\u0001\t\u0001\u0013\u0001\u0010\u0002\t\u0001\u0011\u0001\u0017\u0001\u001f\u0001\u001d\u0001\t\u0001\u001b\u0001-\u0001 \u0001\t\u00012\u0001,\u00013\u0001*\uff81\u0000");
    private static final int[] ZZ_ACTION = MatlabScanner.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0004\u0000\u0001\u0001\u0002\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0001\u0001\u0007\u0001\b\u0001\t\u0001\n\n\u0005\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0005\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u001f\u0002 \u0001!\u0004\u0000\u0001\"\u0001#\u0002\u0000\u0001$\u0001%\u0001&\u0001'\u0001(\u0002\u0007\u0006\u0005\u0001)\u0005\u0005\u0001*\u0001+\u0001,\u0001-\u0001.\u0001/\u0001\u0005\u0001\u001f\u0001\"\u0001\u0000\u0001\b\u00010\u0003\u0005\u00011\u0006\u0005\u00012\u00013\u0001\b\u0003\u0005\u00014\u0003\u0005\u00015\u0007\u0005\u00016\u00017\u0002\u0005\u00018\u00019\u0001:\u0001;\u0002\u0005\u0001<\u0001\u0005\u0001=";
    private static final int[] ZZ_ROWMAP = MatlabScanner.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u00006\u0000l\u0000\u00a2\u0000\u00d8\u0000\u010e\u0000\u00d8\u0000\u0144\u0000\u017a\u0000\u01b0\u0000\u01e6\u0000\u021c\u0000\u0252\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u0288\u0000\u02be\u0000\u02f4\u0000\u032a\u0000\u0360\u0000\u0396\u0000\u03cc\u0000\u0402\u0000\u0438\u0000\u046e\u0000\u017a\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u04a4\u0000\u04da\u0000\u0510\u0000\u0546\u0000\u057c\u0000\u05b2\u0000\u05e8\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u061e\u0000\u0654\u0000\u00d8\u0000\u068a\u0000\u06c0\u0000\u00d8\u0000\u06f6\u0000\u072c\u0000\u0762\u0000\u00d8\u0000\u0798\u0000\u07ce\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u0804\u0000\u00d8\u0000\u083a\u0000\u0870\u0000\u08a6\u0000\u08dc\u0000\u0912\u0000\u0948\u0000\u01b0\u0000\u097e\u0000\u09b4\u0000\u09ea\u0000\u0a20\u0000\u0a56\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u00d8\u0000\u0a8c\u0000\u00d8\u0000\u0ac2\u0000\u0af8\u0000\u0b2e\u0000\u01b0\u0000\u0b64\u0000\u0b9a\u0000\u0bd0\u0000\u01b0\u0000\u0c06\u0000\u0c3c\u0000\u0c72\u0000\u0ca8\u0000\u0cde\u0000\u0d14\u0000\u01b0\u0000\u01b0\u0000\u0d4a\u0000\u0d80\u0000\u0db6\u0000\u0dec\u0000\u0e22\u0000\u0e58\u0000\u0e8e\u0000\u0ec4\u0000\u01b0\u0000\u0efa\u0000\u0f30\u0000\u0f66\u0000\u0f9c\u0000\u0fd2\u0000\u1008\u0000\u103e\u0000\u01b0\u0000\u01b0\u0000\u1074\u0000\u10aa\u0000\u01b0\u0000\u01b0\u0000\u01b0\u0000\u01b0\u0000\u10e0\u0000\u1116\u0000\u01b0\u0000\u114c\u0000\u01b0";
    private static final int[] ZZ_TRANS = MatlabScanner.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\n\u0001\f\u0001\n\u0001\u0005\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0002\n\u0001\u0015\u0001\n\u0001\u0016\u0001\u0017\u0002\n\u0001\u0018\u0002\n\u0001\u0019\u0001\u001a\u0001\n\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0001!\u0001\"\u0001#\u0001$\u0001%\u0001&\u0001'\u0001(\u0001)\u0001*\u0001+\u0001,\u0001-\u0001.\u0001/\u00010\u00011\u00012\u000b0\u00013'0\u000b\u0000\u00014+\u0000\u00015\u00016k\u0000\u0001\u00076\u0000\u0001\b\u0001\u0000\u00017\u00018\u00019\n\u0000\u00017\u0001\u0000\u00017\u00019#\u0000\u0001\b\u0002\u0000\u0001:2\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0012\n\f\u0000\u0001\n\u000b\u0000\u00018\u0002\u0000\u0001;\u0007\u0000\u0001<\u0013\u0000\u0001=\u0001>\u0001?\u0001\u0000\u0001@\u0014\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0005\u0000\u0012\n\f\u0000\u0001\n\b\u0000\u0001\r\u0001A\u0001B3\r\u0003\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0001\n\u0001C\f\n\u0001D\u0003\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0010\n\u0001E\u0001\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0003\n\u0001F\u000e\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0004\n\u0001G\u0002\n\u0001H\n\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0001I\u0011\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\f\n\u0001J\u0005\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0007\n\u0001K\n\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\r\n\u0001L\u0004\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u000b\n\u0001M\u0006\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0002\n\u0001N\u000f\n\f\u0000\u0001\n0\u0000\u0001O5\u0000\u0001P5\u0000\u0001Q5\u0000\u0001R8\u0000\u0001S6\u0000\u0001T\f\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0001\n\u0001U\u0010\n\f\u0000\u0001\n\b\u0000\u00010\u0002\u0000\u000b0\u0001\u0000'0\u0002\u0000\u00012A\u0000\u0001V'\u0000\u00014\u0002\u000034\u0001\u0000\u000157\u0000\u0001W\u0001X\u001c\u0000\u0001X\u0017\u0000\u00018\u0001\u0000\u00017\u0001\u0000\u00019\n\u0000\u00017\u0001\u0000\u00017\u00019#\u0000\u000188\u0000\u0001Y1\u0000\u0001B6\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0002\n\u0001Z\u000f\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0004\n\u0001[\r\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\r\n\u0001\\\u0004\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0010\n\u0001]\u0001\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0005\n\u0001^\f\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\b\n\u0001_\t\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0006\n\u0001`\u000b\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0001\n\u0001a\u0010\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0006\n\u0001b\u000b\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\b\n\u0001c\u0007\n\u0001d\u0001\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0011\n\u0001e\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0002\n\u0001f\u000f\n\f\u0000\u0001\n\u000b\u0000\u0001W\u0003\u0000\u00019\r\u0000\u00019#\u0000\u0001W2\u0000\u0001Y\u0001g\u0001\u000e\nY\u0001\u0000(Y\u0003\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u000f\n\u0001h\u0002\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0003\n\u0001i\u000e\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u000e\n\u0001j\u0003\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0003\n\u0001k\u000e\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0010\n\u0001l\u0001\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\n\n\u0001m\u0007\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0007\n\u0001n\n\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0003\n\u0001o\u000e\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u000f\n\u0001p\u0002\n\f\u0000\u0001\n\n\u0000\u0001\u000e6\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0010\n\u0001q\u0001\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0002\n\u0001r\u000f\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0002\n\u0001s\u000f\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0006\n\u0001t\u000b\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u000f\n\u0001u\u0002\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u000b\n\u0001v\u0006\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0003\n\u0001w\u000e\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\r\n\u0001x\u0004\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0006\n\u0001y\u000b\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\f\n\u0001z\u0005\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0004\n\u0001{\r\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0001|\u0011\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\r\n\u0001}\u0004\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0007\n\u0001~\n\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0001\n\u0001\u007f\u0010\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0006\n\u0001\u0080\u000b\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0004\n\u0001\u0081\r\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\b\n\u0001\u0082\t\n\f\u0000\u0001\n\u000b\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0001\n\u0001\u0000\u0002\n\u0004\u0000\u0003\n\u0001\u0083\u000e\n\f\u0000\u0001\n\b\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = MatlabScanner.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0006\u0001\u0003\t\u000b\u0001\u0005\t\u0007\u0001\b\t\u0002\u0001\u0001\t\u0002\u0001\u0001\t\u0001\u0001\u0001\u0000\u0001\u0001\u0001\t\u0002\u0000\u0005\t\u0001\u0001\u0001\t\f\u0001\u0006\t\u0001\u0001\u0001\t\u0001\u0001\u0001\u0000+\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean[] zzFin = new boolean[16385];
    private static final EnumSet<ETokenType> TRANSPOSE_TYPES = EnumSet.copyOf(Arrays.asList(ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.IMAGINARY_LITERAL, ETokenType.IDENTIFIER, ETokenType.TRANSPOSE, ETokenType.COMPLEX_TRANSPOSE, ETokenType.RBRACK, ETokenType.RPAREN));
    private StringBuilder string = new StringBuilder();
    private String originId;
    private ETokenType lastTokenType;
    private boolean whiteSpaceSinceLastToken = false;

    private static int[] zzUnpackAction() {
        int[] result = new int[131];
        int offset = 0;
        offset = MatlabScanner.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[131];
        int offset = 0;
        offset = MatlabScanner.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[4482];
        int offset = 0;
        offset = MatlabScanner.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[131];
        int offset = 0;
        offset = MatlabScanner.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public void reset(Reader reader, String originId) {
        this.originId = originId;
        this.lastTokenType = null;
        this.whiteSpaceSinceLastToken = false;
        this.yyreset(reader);
    }

    public void close() throws IOException {
        this.yyclose();
    }

    private MatlabToken token(ETokenType type) {
        return new MatlabToken(type, this.yychar, this.yyline, this.yytext(), this.originId);
    }

    public MatlabToken getNextToken() throws IOException {
        MatlabToken token = this.yyGetNextToken();
        this.lastTokenType = token.getType();
        this.whiteSpaceSinceLastToken = false;
        return token;
    }

    MatlabScanner(Reader in, String originId) {
        this.originId = originId;
        this.zzReader = in;
    }

    MatlabScanner(InputStream in, String originId) {
        this(new InputStreamReader(in), originId);
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 134) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public MatlabToken yyGetNextToken() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block133: while (true) {
            int zzInput;
            int zzCurrentPosL;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            boolean zzR = false;
            block134: for (zzCurrentPosL = this.zzStartRead; zzCurrentPosL < zzMarkedPosL; ++zzCurrentPosL) {
                switch (zzBufferL[zzCurrentPosL]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        zzR = false;
                        continue block134;
                    }
                    case '\r': {
                        ++this.yyline;
                        zzR = true;
                        continue block134;
                    }
                    case '\n': {
                        if (zzR) {
                            zzR = false;
                            continue block134;
                        }
                        ++this.yyline;
                        continue block134;
                    }
                    default: {
                        zzR = false;
                    }
                }
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    boolean eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 43: {
                    return this.token(ETokenType.EQEQ);
                }
                case 62: {
                    continue block133;
                }
                case 59: {
                    return this.token(ETokenType.GLOBAL);
                }
                case 63: {
                    continue block133;
                }
                case 57: {
                    return this.token(ETokenType.ELSEIF);
                }
                case 64: {
                    continue block133;
                }
                case 32: {
                    this.yybegin(0);
                    return new MatlabToken(ETokenType.UNTERMINATED_STRING_LITERAL, this.yychar - this.string.length() + 1, this.yyline, this.string.toString(), this.originId);
                }
                case 65: {
                    continue block133;
                }
                case 33: {
                    this.yybegin(0);
                    this.string.append(this.yytext());
                    return new MatlabToken(ETokenType.STRING_LITERAL, this.yychar - this.string.length() + 1, this.yyline, this.string.toString(), this.originId);
                }
                case 66: {
                    continue block133;
                }
                case 25: {
                    return this.token(ETokenType.LBRACK);
                }
                case 67: {
                    continue block133;
                }
                case 19: {
                    return this.token(ETokenType.GT);
                }
                case 68: {
                    continue block133;
                }
                case 39: {
                    return this.token(ETokenType.LEFT_DIV);
                }
                case 69: {
                    continue block133;
                }
                case 7: {
                    int zzFState = 2;
                    int zzFPos = this.zzStartRead;
                    if (this.zzFin.length <= zzBufferL.length) {
                        this.zzFin = new boolean[zzBufferL.length + 1];
                    }
                    boolean[] zzFinL = this.zzFin;
                    while (zzFState != -1 && zzFPos < this.zzMarkedPos) {
                        if ((zzAttrL[zzFState] & 1) == 1) {
                            zzFinL[zzFPos] = true;
                        }
                        zzInput = zzBufferL[zzFPos++];
                        zzFState = zzTransL[zzRowMapL[zzFState] + zzCMapL[zzInput]];
                    }
                    if (zzFState != -1 && (zzAttrL[zzFState] & 1) == 1) {
                        zzFinL[zzFPos] = true;
                    }
                    zzFState = 3;
                    zzFPos = this.zzMarkedPos;
                    while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                        zzInput = zzBufferL[--zzFPos];
                        zzFState = zzTransL[zzRowMapL[zzFState] + zzCMapL[zzInput]];
                    }
                    this.zzMarkedPos = zzFPos;
                    return this.token(ETokenType.END_OF_LINE_COMMENT);
                }
                case 70: {
                    continue block133;
                }
                case 44: {
                    return this.token(ETokenType.GTEQ);
                }
                case 71: {
                    continue block133;
                }
                case 6: {
                    return this.token(ETokenType.DOT);
                }
                case 72: {
                    continue block133;
                }
                case 17: {
                    return this.token(ETokenType.LT);
                }
                case 73: {
                    continue block133;
                }
                case 58: {
                    return this.token(ETokenType.SWITCH);
                }
                case 74: {
                    continue block133;
                }
                case 23: {
                    return this.token(ETokenType.LPAREN);
                }
                case 75: {
                    continue block133;
                }
                case 61: {
                    return this.token(ETokenType.OTHERWISE);
                }
                case 76: {
                    continue block133;
                }
                case 5: {
                    return this.token(ETokenType.IDENTIFIER);
                }
                case 77: {
                    continue block133;
                }
                case 15: {
                    return this.token(ETokenType.COLON);
                }
                case 78: {
                    continue block133;
                }
                case 28: {
                    return this.token(ETokenType.RBRACE);
                }
                case 79: {
                    continue block133;
                }
                case 54: {
                    return this.token(ETokenType.WHILE);
                }
                case 80: {
                    continue block133;
                }
                case 11: {
                    return this.token(ETokenType.PLUS);
                }
                case 81: {
                    continue block133;
                }
                case 46: {
                    return this.token(ETokenType.ANDAND);
                }
                case 82: {
                    continue block133;
                }
                case 34: {
                    return this.token(ETokenType.FLOATING_POINT_LITERAL);
                }
                case 83: {
                    continue block133;
                }
                case 35: {
                    return this.token(ETokenType.IMAGINARY_LITERAL);
                }
                case 84: {
                    continue block133;
                }
                case 21: {
                    return this.token(ETokenType.AND);
                }
                case 85: {
                    continue block133;
                }
                case 53: {
                    return this.token(ETokenType.CASE);
                }
                case 86: {
                    continue block133;
                }
                case 50: {
                    return this.token(ETokenType.TRY);
                }
                case 87: {
                    continue block133;
                }
                case 49: {
                    if (this.lastTokenType == ETokenType.EOL || this.lastTokenType == ETokenType.SEMICOLON) {
                        return this.token(ETokenType.END);
                    }
                    return this.token(ETokenType.IDENTIFIER);
                }
                case 88: {
                    continue block133;
                }
                case 52: {
                    return this.token(ETokenType.ELSE);
                }
                case 89: {
                    continue block133;
                }
                case 36: {
                    return this.token(ETokenType.TRANSPOSE);
                }
                case 90: {
                    continue block133;
                }
                case 38: {
                    return this.token(ETokenType.RIGHT_DIV);
                }
                case 91: {
                    continue block133;
                }
                case 37: {
                    return this.token(ETokenType.MULT);
                }
                case 92: {
                    continue block133;
                }
                case 4: {
                    return this.token(ETokenType.MINUS);
                }
                case 93: {
                    continue block133;
                }
                case 41: {
                    return this.token(ETokenType.IF);
                }
                case 94: {
                    continue block133;
                }
                case 26: {
                    return this.token(ETokenType.RBRACK);
                }
                case 95: {
                    continue block133;
                }
                case 14: {
                    return this.token(ETokenType.MATRIX_LEFT_DIV);
                }
                case 96: {
                    continue block133;
                }
                case 55: {
                    return this.token(ETokenType.CATCH);
                }
                case 97: {
                    continue block133;
                }
                case 45: {
                    return this.token(ETokenType.NOTEQ);
                }
                case 98: {
                    continue block133;
                }
                case 16: {
                    return this.token(ETokenType.MATRIX_POWER);
                }
                case 99: {
                    continue block133;
                }
                case 1: {
                    return this.token(ETokenType.ILLEGAL_CHARACTER);
                }
                case 100: {
                    continue block133;
                }
                case 30: {
                    return this.token(ETokenType.SEMICOLON);
                }
                case 101: {
                    continue block133;
                }
                case 22: {
                    return this.token(ETokenType.OR);
                }
                case 102: {
                    continue block133;
                }
                case 60: {
                    return this.token(ETokenType.FUNCTION);
                }
                case 103: {
                    continue block133;
                }
                case 18: {
                    return this.token(ETokenType.EQ);
                }
                case 104: {
                    continue block133;
                }
                case 24: {
                    return this.token(ETokenType.RPAREN);
                }
                case 105: {
                    continue block133;
                }
                case 29: {
                    return this.token(ETokenType.COMMA);
                }
                case 106: {
                    continue block133;
                }
                case 40: {
                    return this.token(ETokenType.POWER);
                }
                case 107: {
                    continue block133;
                }
                case 8: {
                    this.whiteSpaceSinceLastToken = true;
                }
                case 108: {
                    continue block133;
                }
                case 42: {
                    return this.token(ETokenType.LTEQ);
                }
                case 109: {
                    continue block133;
                }
                case 27: {
                    return this.token(ETokenType.LBRACE);
                }
                case 110: {
                    continue block133;
                }
                case 12: {
                    return this.token(ETokenType.MATRIX_MULT);
                }
                case 111: {
                    continue block133;
                }
                case 2: {
                    return this.token(ETokenType.EOL);
                }
                case 112: {
                    continue block133;
                }
                case 47: {
                    return this.token(ETokenType.OROR);
                }
                case 113: {
                    continue block133;
                }
                case 48: {
                    return this.token(ETokenType.FOR);
                }
                case 114: {
                    continue block133;
                }
                case 10: {
                    if (TRANSPOSE_TYPES.contains((Object)this.lastTokenType) && !this.whiteSpaceSinceLastToken) {
                        return this.token(ETokenType.COMPLEX_TRANSPOSE);
                    }
                    this.yybegin(2);
                    this.string.setLength(0);
                    this.string.append(this.yytext());
                }
                case 115: {
                    continue block133;
                }
                case 20: {
                    return this.token(ETokenType.COMP);
                }
                case 116: {
                    continue block133;
                }
                case 31: {
                    this.string.append(this.yytext());
                }
                case 117: {
                    continue block133;
                }
                case 51: {
                    return this.token(ETokenType.XOR);
                }
                case 118: {
                    continue block133;
                }
                case 9: {
                    --this.yyline;
                }
                case 119: {
                    continue block133;
                }
                case 3: {
                    return this.token(ETokenType.INTEGER_LITERAL);
                }
                case 120: {
                    continue block133;
                }
                case 13: {
                    return this.token(ETokenType.MATRIX_RIGHT_DIV);
                }
                case 121: {
                    continue block133;
                }
                case 56: {
                    return this.token(ETokenType.RETURN);
                }
                case 122: {
                    continue block133;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 2: {
                        this.yybegin(0);
                        return new MatlabToken(ETokenType.UNTERMINATED_STRING_LITERAL, this.yychar - this.string.length() + 1, this.yyline, this.string.toString(), this.originId);
                    }
                    case 132: {
                        continue block133;
                    }
                }
                return this.token(ETokenType.EOF);
            }
            this.zzScanError(1);
        }
    }
}

