/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ILenientScanner;
import org.conqat.lib.scanner.ScannerTestBase;

public class MatlabScannerTest
extends ScannerTestBase {
    protected ELanguage getLanguage() {
        return ELanguage.MATLAB;
    }

    public void testErrorCases() throws IOException {
        this.assertTokens("'unclosed literal\nidentifier", ETokenType.UNTERMINATED_STRING_LITERAL, ETokenType.IDENTIFIER);
        this.assertTokens("'unclosed literal", ETokenType.UNTERMINATED_STRING_LITERAL, ETokenType.EOF);
    }

    public void testIntegerLiterals() throws IOException {
        String[] literals = new String[]{"030", "6", "-14", "0", "+32767"};
        this.batchAssertTokenType(literals, ETokenType.INTEGER_LITERAL);
    }

    public void testFloatingPointLiterals() throws IOException {
        String[] literals = new String[]{"6.6667", "0.0", "-12.0", "3.14159", "+8300.00", ".5", "25.", "2E5", "1.0E-7", "3.14159e0", "-1E38", "-9.5e-3", "101.5E5"};
        this.batchAssertTokenType(literals, ETokenType.FLOATING_POINT_LITERAL);
    }

    public void testImaginaryLiterals() throws IOException {
        String[] literals = new String[]{"6.6667i", "0.0i", "-12.0i", "3.14159i", "+8300.00j", ".5j", "25.j", "2E5j", "1.0E-7j", "3.14159e0j", "-1E38j", "-9.5e-3j", "101.5E5j"};
        this.batchAssertTokenType(literals, ETokenType.IMAGINARY_LITERAL);
    }

    public void testIdentifier() throws IOException {
        String[] identifiers = new String[]{"abc", "X", "t2", "credit_limit", "LastName", "try_again_", "@test"};
        this.batchAssertTokenType(identifiers, ETokenType.IDENTIFIER);
    }

    public void testComments() throws IOException {
        this.assertTokens("% Begin processing", ETokenType.END_OF_LINE_COMMENT);
        this.assertTokens("% Begin processing" + StringUtils.CR + "test", ETokenType.END_OF_LINE_COMMENT, ETokenType.EOL, ETokenType.IDENTIFIER);
        this.assertTokens("test % test comment" + StringUtils.CR + "test", ETokenType.IDENTIFIER, ETokenType.END_OF_LINE_COMMENT, ETokenType.EOL, ETokenType.IDENTIFIER);
    }

    public void testOperators() throws IOException {
        this.assertToken("+", ETokenType.PLUS);
        this.assertToken("-", ETokenType.MINUS);
        this.assertToken(".*", ETokenType.MULT);
        this.assertToken("./", ETokenType.RIGHT_DIV);
        this.assertToken(".\\", ETokenType.LEFT_DIV);
        this.assertToken(":", ETokenType.COLON);
        this.assertToken(".^", ETokenType.POWER);
        this.assertToken(".'", ETokenType.TRANSPOSE);
        this.assertToken("*", ETokenType.MATRIX_MULT);
        this.assertToken("/", ETokenType.MATRIX_RIGHT_DIV);
        this.assertToken("\\", ETokenType.MATRIX_LEFT_DIV);
        this.assertToken("^", ETokenType.MATRIX_POWER);
        this.assertToken("<", ETokenType.LT);
        this.assertToken("<=", ETokenType.LTEQ);
        this.assertToken(">", ETokenType.GT);
        this.assertToken(">=", ETokenType.GTEQ);
        this.assertToken("==", ETokenType.EQEQ);
        this.assertToken("~=", ETokenType.NOTEQ);
        this.assertToken("&", ETokenType.AND);
        this.assertToken("|", ETokenType.OR);
        this.assertToken("~", ETokenType.COMP);
        this.assertToken("xor", ETokenType.XOR);
        this.assertToken("&&", ETokenType.ANDAND);
        this.assertToken("||", ETokenType.OROR);
        this.assertToken("=", ETokenType.EQ);
    }

    public void testDelimiters() throws IOException {
        this.assertTokens("()", ETokenType.LPAREN, ETokenType.RPAREN);
        this.assertTokens("[]", ETokenType.LBRACK, ETokenType.RBRACK);
        this.assertTokens("{}", ETokenType.LBRACE, ETokenType.RBRACE);
        this.assertToken(",", ETokenType.COMMA);
        this.assertToken(";", ETokenType.SEMICOLON);
        this.assertToken(".", ETokenType.DOT);
    }

    public void testKeywords() throws IOException {
        this.assertTokens("for if else elseif global while function return switch case otherwise try catch", ETokenType.FOR, ETokenType.IF, ETokenType.ELSE, ETokenType.ELSEIF, ETokenType.GLOBAL, ETokenType.WHILE, ETokenType.FUNCTION, ETokenType.RETURN, ETokenType.SWITCH, ETokenType.CASE, ETokenType.OTHERWISE, ETokenType.TRY, ETokenType.CATCH);
    }

    public void testEnd() throws IOException {
        this.assertTokens("(1:end)", ETokenType.LPAREN, ETokenType.INTEGER_LITERAL, ETokenType.COLON, ETokenType.IDENTIFIER, ETokenType.RPAREN);
        this.assertTokens("(1,end)", ETokenType.LPAREN, ETokenType.INTEGER_LITERAL, ETokenType.COMMA, ETokenType.IDENTIFIER, ETokenType.RPAREN);
        this.assertTokens("\n end", ETokenType.EOL, ETokenType.END);
        this.assertTokens("; end", ETokenType.SEMICOLON, ETokenType.END);
    }

    public void testStringLiterals() throws IOException {
        this.assertTokens("''", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'test' 'test'", ETokenType.STRING_LITERAL, ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'Hello, world!'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'XYZ Corporation'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'10-NOV-91'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'He said \"Life is like licking honey from a thorn.\"'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'$1,000,000'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'I''m a string, you''re a string.'", ETokenType.STRING_LITERAL, ETokenType.EOF);
    }

    public void testSingleQuote() throws IOException {
        this.assertTokens("3'", ETokenType.INTEGER_LITERAL, ETokenType.COMPLEX_TRANSPOSE);
        this.assertTokens("3.5'", ETokenType.FLOATING_POINT_LITERAL, ETokenType.COMPLEX_TRANSPOSE);
        this.assertTokens("3.5i'", ETokenType.IMAGINARY_LITERAL, ETokenType.COMPLEX_TRANSPOSE);
        this.assertTokens("test'", ETokenType.IDENTIFIER, ETokenType.COMPLEX_TRANSPOSE);
        this.assertTokens(".''", ETokenType.TRANSPOSE, ETokenType.COMPLEX_TRANSPOSE);
        this.assertTokens("3.5''", ETokenType.FLOATING_POINT_LITERAL, ETokenType.COMPLEX_TRANSPOSE, ETokenType.COMPLEX_TRANSPOSE);
        this.assertTokens("]'", ETokenType.RBRACK, ETokenType.COMPLEX_TRANSPOSE);
        this.assertTokens(")'", ETokenType.RPAREN, ETokenType.COMPLEX_TRANSPOSE);
        this.assertTokens("A '+1'", ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL);
        this.assertTokens("A'+1'", ETokenType.IDENTIFIER, ETokenType.COMPLEX_TRANSPOSE, ETokenType.INTEGER_LITERAL, ETokenType.COMPLEX_TRANSPOSE);
    }

    public void testLineContinuation() throws IOException {
        this.assertTokens("test..." + StringUtils.CR + "test", ETokenType.IDENTIFIER, ETokenType.IDENTIFIER);
        this.assertTokens("test... " + StringUtils.CR + "test", ETokenType.IDENTIFIER, ETokenType.IDENTIFIER);
    }

    public void testAssertLineNumbers() throws Exception {
        ILenientScanner scanner = this.getScannerFor("a" + StringUtils.CR + StringUtils.CR + "b..." + StringUtils.CR + "c");
        this.assertTokenLineNumbers(scanner);
    }
}

