/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ILenientScanner;
import org.conqat.lib.scanner.IScanner;
import org.conqat.lib.scanner.IToken;
import org.conqat.lib.scanner.PHPToken;
import org.conqat.lib.scanner.ScannerException;
import org.conqat.lib.scanner.ScannerTestBase;

public class PHPScannerTest
extends ScannerTestBase {
    protected ELanguage getLanguage() {
        return ELanguage.PHP;
    }

    private void debugTokens(String text) {
        ILenientScanner scanner = this.getScannerFor(text);
        try {
            IToken token;
            while ((token = scanner.getNextToken()).getType() != ETokenType.EOF) {
                System.out.println((Object)token.getType());
                System.out.println(token.getText());
                System.out.println(token.getLineNumber());
                System.out.println("");
            }
        }
        catch (Exception e) {
            System.out.println("Excpetion: " + e.toString());
        }
    }

    public void testIllegalCharacter() throws IOException {
        String s = "<?php \u00b2 identifier";
        this.assertTokens(s, ETokenType.PHP_BEGIN, ETokenType.ILLEGAL_CHARACTER, ETokenType.IDENTIFIER, ETokenType.EOF);
    }

    public void testErrorCases() throws IOException {
    }

    protected void assertPHPToken(String php, ETokenType type) throws IOException {
        this.assertTokens("<?php " + php, ETokenType.PHP_BEGIN, type);
    }

    protected void assertPHPTokens(String php, ETokenType ... types) throws IOException {
        php = "<?php " + php;
        ILenientScanner scanner = this.getScannerFor(php);
        IToken token = scanner.getNextToken();
        PHPScannerTest.assertEquals((String)("Type mismatch in PHP:" + php), (Object)((Object)ETokenType.PHP_BEGIN), (Object)((Object)token.getType()));
        for (int i = 0; i < types.length; ++i) {
            ETokenType type = types[i];
            token = scanner.getNextToken();
            PHPScannerTest.assertEquals((String)("Type mismatch in PHP:" + php), (Object)((Object)type), (Object)((Object)token.getType()));
        }
        PHPScannerTest.assertEquals((String)("More tokens found than expected token types specified in text" + php), (Object)((Object)ETokenType.EOF), (Object)((Object)scanner.getNextToken().getType()));
    }

    public void testDoubleQuotedStringLiteralErrorCases() throws IOException {
        this.assertPHPToken("\"ua\n identifier", ETokenType.UNTERMINATED_STRING_LITERAL);
        this.assertPHPTokens("Identifier \"ua\\\"", ETokenType.IDENTIFIER, ETokenType.UNTERMINATED_STRING_LITERAL);
    }

    public void testSingleQuotedStringLiteralErrorCases() throws IOException {
        this.assertPHPToken("'ua\n identifier", ETokenType.UNTERMINATED_STRING_LITERAL);
        this.assertPHPTokens("Identifier 'ua\\' ?>", ETokenType.IDENTIFIER, ETokenType.UNTERMINATED_STRING_LITERAL);
    }

    public void testIntegerLiteral() throws IOException {
        this.assertPHPToken("0", ETokenType.INTEGER_LITERAL);
        this.assertPHPToken("1", ETokenType.INTEGER_LITERAL);
        this.assertPHPToken("123", ETokenType.INTEGER_LITERAL);
    }

    public void testHexIntegerLiteral() throws IOException {
        this.assertPHPToken("0xA", ETokenType.INTEGER_LITERAL);
        this.assertPHPToken("0x1A", ETokenType.INTEGER_LITERAL);
    }

    public void testOctalIntegerLiteral() throws IOException {
        this.assertPHPToken("023", ETokenType.INTEGER_LITERAL);
    }

    public void testExponentFloatLiteral() throws IOException {
        this.assertPHPToken("1.2e3", ETokenType.FLOATING_POINT_LITERAL);
        this.assertPHPToken("7E-10", ETokenType.FLOATING_POINT_LITERAL);
    }

    public void testBoolLiteral() throws IOException {
        this.assertPHPToken("true", ETokenType.BOOLEAN_LITERAL);
        this.assertPHPToken("True", ETokenType.BOOLEAN_LITERAL);
        this.assertPHPToken("TRUE", ETokenType.BOOLEAN_LITERAL);
        this.assertPHPToken("false", ETokenType.BOOLEAN_LITERAL);
        this.assertPHPToken("False", ETokenType.BOOLEAN_LITERAL);
        this.assertPHPToken("FALSE", ETokenType.BOOLEAN_LITERAL);
    }

    public void testSimpleDoubleQuotedStringLiteral() throws IOException {
        this.assertPHPToken("\"test\"", ETokenType.STRING_LITERAL);
    }

    public void testSimpleSingleQuotedStringLiteral() throws IOException {
        this.assertPHPToken("'test'", ETokenType.STRING_LITERAL);
    }

    public void testEscapedSingleQuotedStringLiteral() throws IOException {
        this.assertPHPToken("'\\\\'", ETokenType.STRING_LITERAL);
        this.assertPHPToken("'test\\\\test'", ETokenType.STRING_LITERAL);
        this.assertPHPToken("'test\\'test'", ETokenType.STRING_LITERAL);
    }

    public void testEscapedDoubleQuotedStringLiteral() throws IOException {
        this.assertPHPToken("\"test\\\\test\"", ETokenType.STRING_LITERAL);
        this.assertPHPToken("\"test\\\"test\"", ETokenType.STRING_LITERAL);
        this.assertPHPToken("\"test\\$test\"", ETokenType.STRING_LITERAL);
        this.assertPHPToken("\"test\\ntest\"", ETokenType.STRING_LITERAL);
        this.assertPHPToken("\"test\\rtest\"", ETokenType.STRING_LITERAL);
        this.assertPHPToken("\"test\\ttest\"", ETokenType.STRING_LITERAL);
        this.assertPHPToken("\"test\\{test\"", ETokenType.STRING_LITERAL);
        this.assertPHPToken("\"test\\}test\"", ETokenType.STRING_LITERAL);
        this.assertPHPToken("\"test\\[test\"", ETokenType.STRING_LITERAL);
        this.assertPHPToken("\"test\\]test\"", ETokenType.STRING_LITERAL);
        this.assertPHPToken("\"test\\023test\"", ETokenType.STRING_LITERAL);
        this.assertPHPToken("\"test\\x23test\"", ETokenType.STRING_LITERAL);
        this.assertPHPToken("\"test\\ptest\"", ETokenType.STRING_LITERAL);
    }

    public void testStringQuoting() throws IOException {
        this.assertPHPToken("'test\\'\"test2'", ETokenType.STRING_LITERAL);
        this.assertPHPToken("\"test\\\"'test2'\"", ETokenType.STRING_LITERAL);
    }

    public void testMultilineStringLiteral() throws IOException {
        this.assertPHPToken("'test\n\ttest2'", ETokenType.STRING_LITERAL);
        this.assertPHPToken("\"test\n\ttest2\"", ETokenType.STRING_LITERAL);
    }

    public void testComments() throws IOException {
        this.assertPHPToken("// test", ETokenType.END_OF_LINE_COMMENT);
        this.assertPHPToken("/* test\n test */", ETokenType.TRADITIONAL_COMMENT);
        this.assertPHPToken("/** test\n test */", ETokenType.DOCUMENTATION_COMMENT);
        this.assertPHPToken("# test", ETokenType.HASH_COMMENT);
    }

    public void testHeredoc() throws IOException {
        String heredoc = "<<<END_OF_HEREDOC\nThe Content\nTest\n\nEND_OF_HEREDOC;";
        this.assertPHPTokens(heredoc, ETokenType.PHP_HEREDOC, ETokenType.SEMICOLON);
        heredoc = "$foo = " + heredoc;
        this.assertPHPTokens(heredoc, ETokenType.PHP_VARIABLE, ETokenType.EQ, ETokenType.PHP_HEREDOC, ETokenType.SEMICOLON);
    }

    public void testIllegalCharacterBackslash() throws IOException {
        String testString = "<?php test \\o";
        PHPScannerTest.assertTrue((boolean)this.findProblem(testString));
    }

    public void testKeywordNameFunction() throws IOException {
        this.assertPHPToken("integer", ETokenType.INTEGER);
        this.assertPHPTokens("(integer)", ETokenType.LPAREN, ETokenType.INTEGER, ETokenType.RPAREN);
        this.assertPHPTokens("function float(", ETokenType.FUNCTION, ETokenType.IDENTIFIER, ETokenType.LPAREN);
        this.assertPHPTokens("class Integer {", ETokenType.CLASS, ETokenType.IDENTIFIER, ETokenType.LBRACE);
        this.assertPHPTokens("$foo->double(", ETokenType.PHP_VARIABLE, ETokenType.PHP_INSTANCE_CALL, ETokenType.IDENTIFIER, ETokenType.LPAREN);
        this.assertPHPTokens("Integer::float(", ETokenType.IDENTIFIER, ETokenType.PHP_STATIC_CALL, ETokenType.IDENTIFIER, ETokenType.LPAREN);
        this.assertPHPTokens("new Integer", ETokenType.NEW, ETokenType.IDENTIFIER);
        this.assertPHPTokens("integer(", ETokenType.IDENTIFIER, ETokenType.LPAREN);
    }

    public void testAssertLineNumbers() throws Exception {
        ILenientScanner scanner = this.getScannerFor("<? a" + StringUtils.CR + StringUtils.CR + "b");
        this.assertTokenLineNumbers(scanner);
    }

    public void testAssertLineNumbersCorrectWhenFormFeedsArePresent() throws Exception {
        ILenientScanner scanner = this.getScannerFor("<? a" + StringUtils.CR + "\f" + StringUtils.CR + "b");
        this.assertTokenLineNumbers(scanner);
    }

    protected void assertTokenLineNumbers(IScanner scanner) throws IOException, ScannerException {
        IToken token = scanner.getNextToken();
        PHPScannerTest.assertEquals((int)0, (int)token.getLineNumber());
        scanner.getNextToken();
        token = scanner.getNextToken();
        PHPScannerTest.assertEquals((int)2, (int)token.getLineNumber());
    }

    public void testIllegalUnterminatedStringLiteral() throws IOException {
        String testString = "<?php \"test\ntest2";
        PHPScannerTest.assertTrue((boolean)this.findProblem(testString));
    }

    public void testIllegalUnterminatedStringLiteral2() throws IOException {
        String testString = "<?php test\"\ntest2";
        PHPScannerTest.assertTrue((boolean)this.findProblem(testString));
    }

    public void testIllegalUnterminatedCharLiteral() throws IOException {
        String testString = "<?php '\ntest2";
        PHPScannerTest.assertTrue((boolean)this.findProblem(testString));
    }

    public void testBacktickStringLiteral() throws IOException {
        this.assertPHPToken("`ls`", ETokenType.BACKTICK_STRING_LITERAL);
        this.assertPHPTokens("$ls = `ls`", ETokenType.PHP_VARIABLE, ETokenType.EQ, ETokenType.BACKTICK_STRING_LITERAL);
        this.assertPHPTokens("$ls = `\\$PATH`", ETokenType.PHP_VARIABLE, ETokenType.EQ, ETokenType.BACKTICK_STRING_LITERAL);
    }

    public void testVariables() throws IOException {
        this.assertPHPToken("$asf_1", ETokenType.PHP_VARIABLE);
        this.assertPHPTokens("$$var += $foo", ETokenType.PHP_VARIABLE, ETokenType.PLUSEQ, ETokenType.PHP_VARIABLE);
        this.assertPHPTokens("$view->some_version =", ETokenType.PHP_VARIABLE, ETokenType.PHP_INSTANCE_CALL, ETokenType.IDENTIFIER, ETokenType.EQ);
    }

    public void testPHPBrackets() throws IOException {
        this.assertTokens("<? 1", ETokenType.PHP_BEGIN, ETokenType.INTEGER_LITERAL);
        this.assertTokens("<?php 1", ETokenType.PHP_BEGIN, ETokenType.INTEGER_LITERAL);
        this.assertTokens("<? 1 ?>", ETokenType.PHP_BEGIN, ETokenType.INTEGER_LITERAL, ETokenType.PHP_END);
        this.assertTokens("<b>test</b><? 1", ETokenType.PHP_DIRECT_OUTPUT, ETokenType.PHP_BEGIN, ETokenType.INTEGER_LITERAL);
        this.assertTokens("test\ntest2 <?php 123\n?> test3", ETokenType.PHP_DIRECT_OUTPUT, ETokenType.PHP_BEGIN, ETokenType.INTEGER_LITERAL, ETokenType.PHP_END, ETokenType.PHP_DIRECT_OUTPUT);
    }

    public void testVariablesInStrings() throws IOException {
        this.assertStringContainsVariables("\"test $varOne_FO__O test2 $var2\"", ETokenType.STRING_LITERAL, "$varOne_FO__O", "$var2");
        this.assertStringContainsVariables("\"test $var test2 \\$var2\"", ETokenType.STRING_LITERAL, "$var");
        this.assertStringContainsVariables("'test $var test2 $var2'", ETokenType.STRING_LITERAL, new String[0]);
        this.assertStringContainsVariables("`test $var test2 $var2`", ETokenType.BACKTICK_STRING_LITERAL, "$var", "$var2");
        this.assertStringContainsVariables("`test $var test2 \\$var2`", ETokenType.BACKTICK_STRING_LITERAL, "$var");
        this.assertStringContainsVariables("\"/^[$allowed][\\.$allowed]{0,63}$/\"", ETokenType.STRING_LITERAL, "$allowed");
    }

    private void assertStringContainsVariables(String text, ETokenType stringType, String ... expectedVariables) throws IOException {
        text = "<? " + text;
        ILenientScanner scanner = this.getScannerFor(text);
        PHPToken token = (PHPToken)scanner.getNextToken();
        PHPScannerTest.assertEquals((String)("Type mismatch in:" + text), (Object)((Object)ETokenType.PHP_BEGIN), (Object)((Object)token.getType()));
        token = (PHPToken)scanner.getNextToken();
        PHPScannerTest.assertEquals((String)("Type mismatch in:" + text), (Object)((Object)stringType), (Object)((Object)token.getType()));
        Set<String> actualVariables = token.getContainedVariables();
        if (expectedVariables.length == 0) {
            PHPScannerTest.assertFalse((String)("Unexpected variables found in: " + text), (boolean)token.containsVariables());
        } else {
            PHPScannerTest.assertNotNull((String)("No variables found in: " + text), actualVariables);
            for (String expected : expectedVariables) {
                boolean contains = actualVariables.contains(expected);
                PHPScannerTest.assertTrue((String)("Expected variable " + expected + " in: " + text), (boolean)contains);
            }
            List<String> expectedVariablesList = Arrays.asList(expectedVariables);
            for (String actual : actualVariables) {
                boolean contains = expectedVariablesList.contains(actual);
                PHPScannerTest.assertTrue((String)("Found unexpected variable " + actual + " in: " + text), (boolean)contains);
            }
        }
        PHPScannerTest.assertEquals((String)("More than one token found in: " + text), (Object)((Object)ETokenType.EOF), (Object)((Object)scanner.getNextToken().getType()));
    }

    public void testYYIdentifier() throws Exception {
        ILenientScanner scanner = this.getScannerFor("<?php Id1 Id2");
        IToken idToken1 = scanner.getNextToken();
        this.assertTokenOffset(idToken1, ETokenType.PHP_BEGIN, 0);
        IToken idToken2 = scanner.getNextToken();
        this.assertTokenOffset(idToken2, ETokenType.IDENTIFIER, 6);
        IToken idToken3 = scanner.getNextToken();
        this.assertTokenOffset(idToken3, ETokenType.IDENTIFIER, 10);
    }

    public void testYYStringLiteral() throws Exception {
        ILenientScanner scanner = this.getScannerFor("<?php \"Stringliteral1\" 'Stringliteral2' Identifier");
        IToken literalToken0 = scanner.getNextToken();
        this.assertTokenOffset(literalToken0, ETokenType.PHP_BEGIN, 0);
        IToken literalToken1 = scanner.getNextToken();
        this.assertTokenOffset(literalToken1, ETokenType.STRING_LITERAL, 6);
        IToken literalToken2 = scanner.getNextToken();
        this.assertTokenOffset(literalToken2, ETokenType.STRING_LITERAL, 23);
        IToken identifierToken = scanner.getNextToken();
        this.assertTokenOffset(identifierToken, ETokenType.IDENTIFIER, 40);
    }

    public void testInstanceCall() throws IOException {
        this.assertPHPTokens("$this->class = $this->$class;", ETokenType.THIS, ETokenType.PHP_INSTANCE_CALL, ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.THIS, ETokenType.PHP_INSTANCE_CALL, ETokenType.PHP_VARIABLE, ETokenType.SEMICOLON);
    }
}

