/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ScannerTestBase;

public class PythonScannerTest
extends ScannerTestBase {
    protected ELanguage getLanguage() {
        return ELanguage.PYTHON;
    }

    public void testErrorCases() throws IOException {
        this.assertInvalidDedent();
        this.assertBracketMismatch();
    }

    private void assertBracketMismatch() throws IOException {
        this.assertTokens("]test", ETokenType.BRACKET_MISMATCH, ETokenType.IDENTIFIER);
        this.assertTokens("])}test", ETokenType.BRACKET_MISMATCH, ETokenType.BRACKET_MISMATCH, ETokenType.BRACKET_MISMATCH, ETokenType.IDENTIFIER);
        this.assertTokens("[test]], test", ETokenType.LBRACK, ETokenType.IDENTIFIER, ETokenType.RBRACK, ETokenType.BRACKET_MISMATCH, ETokenType.COMMA, ETokenType.IDENTIFIER);
        this.assertTokens("[test" + StringUtils.CR + ",test] test" + StringUtils.CR + "test]", ETokenType.LBRACK, ETokenType.IDENTIFIER, ETokenType.COMMA, ETokenType.IDENTIFIER, ETokenType.RBRACK, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.IDENTIFIER, ETokenType.BRACKET_MISMATCH);
    }

    private void assertInvalidDedent() throws IOException {
        this.assertTokens(this.indent(1) + "test" + StringUtils.CR + this.indent(3) + "test" + StringUtils.CR + this.indent(2) + "test" + StringUtils.CR + this.indent(1) + "test", ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.INVALID_DEDENT, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.DEDENT, ETokenType.IDENTIFIER, ETokenType.DEDENT);
    }

    public void testLineBreaks() throws IOException {
        this.assertTokens("abc" + StringUtils.CR + "ABC", ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.IDENTIFIER);
        this.assertTokens("abc\\" + StringUtils.CR + "ABC", ETokenType.IDENTIFIER, ETokenType.IDENTIFIER);
        this.assertTokens("abc\\ " + StringUtils.CR + "ABC", ETokenType.IDENTIFIER, ETokenType.IDENTIFIER);
        this.assertTokens("abc\\ " + StringUtils.CR + this.indent(1) + "ABC", ETokenType.IDENTIFIER, ETokenType.IDENTIFIER);
        this.assertTokens("['Test1', 'Test2'," + StringUtils.CR + "'December']", ETokenType.LBRACK, ETokenType.STRING_LITERAL, ETokenType.COMMA, ETokenType.STRING_LITERAL, ETokenType.COMMA, ETokenType.STRING_LITERAL, ETokenType.RBRACK);
        this.assertTokens("['Test1', 'Test2'," + StringUtils.CR + "'December']" + StringUtils.CR + "hallo", ETokenType.LBRACK, ETokenType.STRING_LITERAL, ETokenType.COMMA, ETokenType.STRING_LITERAL, ETokenType.COMMA, ETokenType.STRING_LITERAL, ETokenType.RBRACK, ETokenType.EOL, ETokenType.IDENTIFIER);
        this.assertTokens("['Test1', 'Test2'," + StringUtils.CR + this.indent(1) + "'December']" + StringUtils.CR + "hallo", ETokenType.LBRACK, ETokenType.STRING_LITERAL, ETokenType.COMMA, ETokenType.STRING_LITERAL, ETokenType.COMMA, ETokenType.STRING_LITERAL, ETokenType.RBRACK, ETokenType.EOL, ETokenType.IDENTIFIER);
        this.assertTokens("['Test1', 'Test2', # comment" + StringUtils.CR + "'December']" + StringUtils.CR + "hallo", ETokenType.LBRACK, ETokenType.STRING_LITERAL, ETokenType.COMMA, ETokenType.STRING_LITERAL, ETokenType.COMMA, ETokenType.END_OF_LINE_COMMENT, ETokenType.STRING_LITERAL, ETokenType.RBRACK, ETokenType.EOL, ETokenType.IDENTIFIER);
    }

    public void testIdentifier() throws IOException {
        this.assertToken("abc", ETokenType.IDENTIFIER);
        this.assertToken("X", ETokenType.IDENTIFIER);
        this.assertToken("t2", ETokenType.IDENTIFIER);
        this.assertToken("credit_limit", ETokenType.IDENTIFIER);
        this.assertToken("LastName", ETokenType.IDENTIFIER);
        this.assertToken("try_again_", ETokenType.IDENTIFIER);
        this.assertToken("_abc", ETokenType.IDENTIFIER);
        this.assertToken("__abc", ETokenType.IDENTIFIER);
        this.assertToken("__abc__", ETokenType.IDENTIFIER);
    }

    public void testIntegerLiterals() throws IOException {
        this.assertToken("7", ETokenType.INTEGER_LITERAL);
        this.assertToken("2147483647", ETokenType.INTEGER_LITERAL);
        this.assertToken("0o177", ETokenType.INTEGER_LITERAL);
        this.assertToken("0b100110111", ETokenType.INTEGER_LITERAL);
        this.assertToken("3", ETokenType.INTEGER_LITERAL);
        this.assertToken("79228162514264337593543950336", ETokenType.INTEGER_LITERAL);
        this.assertToken("0o377", ETokenType.INTEGER_LITERAL);
        this.assertToken("0x100000000", ETokenType.INTEGER_LITERAL);
        this.assertToken("79228162514264337593543950336", ETokenType.INTEGER_LITERAL);
        this.assertToken("0xdeadbeef", ETokenType.INTEGER_LITERAL);
    }

    public void testFloatingPointLiterals() throws IOException {
        this.assertToken("3.14", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("10.", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken(".001", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("1e100", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("3.14e-10", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("0e0", ETokenType.FLOATING_POINT_LITERAL);
    }

    public void testImaginaryLiterals() throws IOException {
        this.assertToken("3.14j", ETokenType.IMAGINARY_LITERAL);
        this.assertToken("10.j", ETokenType.IMAGINARY_LITERAL);
        this.assertToken("10j", ETokenType.IMAGINARY_LITERAL);
        this.assertToken(".001j", ETokenType.IMAGINARY_LITERAL);
        this.assertToken("1e100j", ETokenType.IMAGINARY_LITERAL);
        this.assertToken("3.14e-10j", ETokenType.IMAGINARY_LITERAL);
    }

    public void testStringLiterals() throws IOException {
        this.assertTokens("''", ETokenType.STRING_LITERAL);
        this.assertTokens("\"\"", ETokenType.STRING_LITERAL);
        this.assertTokens("'abc'", ETokenType.STRING_LITERAL);
        this.assertTokens("\"abc\"", ETokenType.STRING_LITERAL);
        this.assertTokens("'abc\\xa'", ETokenType.STRING_LITERAL);
        this.assertTokens("\"abc\\xa\"", ETokenType.STRING_LITERAL);
        this.assertTokens("'''abc" + StringUtils.CR + "abc'''", ETokenType.STRING_LITERAL);
        this.assertTokens("\"\"\"abc" + StringUtils.CR + "abc\"\"\"", ETokenType.STRING_LITERAL);
        this.assertTokens("'''abc" + StringUtils.CR + "  abc'''", ETokenType.STRING_LITERAL);
        this.assertTokens("\"\"\"abc" + StringUtils.CR + "  abc\"\"\"", ETokenType.STRING_LITERAL);
        this.assertTokens("'''abc\\xa" + StringUtils.CR + "abc'''", ETokenType.STRING_LITERAL);
        this.assertTokens("\"\"\"abc\\xa" + StringUtils.CR + "abc\"\"\"", ETokenType.STRING_LITERAL);
        this.assertTokens("'a\\'b'", ETokenType.STRING_LITERAL);
        this.assertTokens("\"a\\\"b\"", ETokenType.STRING_LITERAL);
        this.assertTokens("'\\x00=\"\\'a\\\\b\\x80\\xff\\u0000\\u0001\\u1234'", ETokenType.STRING_LITERAL);
        this.assertTokens("'/\\\\': ('/', '\\\\')", ETokenType.STRING_LITERAL, ETokenType.COLON, ETokenType.LPAREN, ETokenType.STRING_LITERAL, ETokenType.COMMA, ETokenType.STRING_LITERAL, ETokenType.RPAREN);
        this.assertTokens("warn('distutils.command.sdist.check_metadata is deprecated, \\" + StringUtils.CR + "      use the check command instead', PendingDeprecationWarning)", ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.STRING_LITERAL, ETokenType.COMMA, ETokenType.IDENTIFIER, ETokenType.RPAREN);
        this.assertTokens("test_file = os.path.join(test_dir, 'cmath_testcases.txt')" + StringUtils.CR + StringUtils.CR + "def parse_testfile(fname):" + StringUtils.CR + "    \"\"\"Parse a file with test values" + StringUtils.CR + "" + StringUtils.CR + "    Empty lines or lines starting with -- are ignored" + StringUtils.CR + "    yields id, fn, arg_real, arg_imag, exp_real, exp_imag" + StringUtils.CR + "    \"\"\"" + StringUtils.CR + "    with open(fname) as fp:" + StringUtils.CR + "        for line in fp:", ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.COMMA, ETokenType.STRING_LITERAL, ETokenType.RPAREN, ETokenType.EOL, ETokenType.DEF, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.COLON, ETokenType.EOL, ETokenType.INDENT, ETokenType.STRING_LITERAL, ETokenType.EOL, ETokenType.WITH, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.AS, ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.EOL, ETokenType.INDENT, ETokenType.FOR, ETokenType.IDENTIFIER, ETokenType.IN, ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.DEDENT, ETokenType.DEDENT);
    }

    public void testComments() throws IOException {
        this.assertTokens("# Begin processing", ETokenType.END_OF_LINE_COMMENT);
        this.assertTokens("# Begin processing" + StringUtils.CR + "test", ETokenType.END_OF_LINE_COMMENT, ETokenType.EOL, ETokenType.IDENTIFIER);
        this.assertTokens("test # test comment" + StringUtils.CR + "test", ETokenType.IDENTIFIER, ETokenType.END_OF_LINE_COMMENT, ETokenType.EOL, ETokenType.IDENTIFIER);
        this.assertTokens("##         # Netscape protocol doesn't allow non-special top level domains (such", ETokenType.END_OF_LINE_COMMENT);
    }

    public void testKeywords() throws IOException {
        this.assertToken("and", ETokenType.AND);
        this.assertToken("as", ETokenType.AS);
        this.assertToken("assert", ETokenType.ASSERT);
        this.assertToken("break", ETokenType.BREAK);
        this.assertToken("class", ETokenType.CLASS);
        this.assertToken("continue", ETokenType.CONTINUE);
        this.assertToken("def", ETokenType.DEF);
        this.assertToken("del", ETokenType.DEL);
        this.assertToken("elif", ETokenType.ELIF);
        this.assertToken("else", ETokenType.ELSE);
        this.assertToken("except", ETokenType.EXCEPT);
        this.assertToken("False", ETokenType.FALSE);
        this.assertToken("finally", ETokenType.FINALLY);
        this.assertToken("for", ETokenType.FOR);
        this.assertToken("from", ETokenType.FROM);
        this.assertToken("global", ETokenType.GLOBAL);
        this.assertToken("if", ETokenType.IF);
        this.assertToken("import", ETokenType.IMPORT);
        this.assertToken("in", ETokenType.IN);
        this.assertToken("is", ETokenType.IS);
        this.assertToken("lambda", ETokenType.LAMBDA);
        this.assertToken("None", ETokenType.NONE);
        this.assertToken("nonlocal", ETokenType.NONLOCAL);
        this.assertToken("not", ETokenType.NOT);
        this.assertToken("or", ETokenType.OR);
        this.assertToken("pass", ETokenType.PASS);
        this.assertToken("raise", ETokenType.RAISE);
        this.assertToken("return", ETokenType.RETURN);
        this.assertToken("True", ETokenType.TRUE);
        this.assertToken("try", ETokenType.TRY);
        this.assertToken("while", ETokenType.WHILE);
        this.assertToken("with", ETokenType.WITH);
        this.assertToken("yield", ETokenType.YIELD);
    }

    public void testOperators() throws IOException {
        this.assertToken("+", ETokenType.PLUS);
        this.assertToken("-", ETokenType.MINUS);
        this.assertToken("*", ETokenType.MULT);
        this.assertToken("/", ETokenType.DIV);
        this.assertToken("**", ETokenType.POWER);
        this.assertToken("//", ETokenType.FLOOR_DIV);
        this.assertToken("%", ETokenType.MOD);
        this.assertToken("<<", ETokenType.LSHIFT);
        this.assertToken(">>", ETokenType.RSHIFT);
        this.assertToken("&", ETokenType.AND);
        this.assertToken("|", ETokenType.OR);
        this.assertToken("^", ETokenType.XOR);
        this.assertToken("~", ETokenType.BIT_NOT);
        this.assertToken("<=", ETokenType.LTEQ);
        this.assertToken(">=", ETokenType.GTEQ);
        this.assertToken("!=", ETokenType.NOTEQ);
        this.assertToken("==", ETokenType.EQEQ);
        this.assertToken(">", ETokenType.GT);
        this.assertToken("<", ETokenType.LT);
    }

    public void testDelimiters() throws IOException {
        this.assertTokens("()", ETokenType.LPAREN, ETokenType.RPAREN);
        this.assertTokens("{}", ETokenType.LBRACE, ETokenType.RBRACE);
        this.assertTokens("[]", ETokenType.LBRACK, ETokenType.RBRACK);
        this.assertToken("=", ETokenType.EQ);
        this.assertToken(";", ETokenType.SEMICOLON);
        this.assertToken(",", ETokenType.COMMA);
        this.assertToken(".", ETokenType.DOT);
        this.assertToken(":", ETokenType.COLON);
        this.assertToken("@", ETokenType.AT);
        this.assertToken("+=", ETokenType.PLUSEQ);
        this.assertToken("-=", ETokenType.MINUSEQ);
        this.assertToken("*=", ETokenType.MULTEQ);
        this.assertToken("/=", ETokenType.DIVEQ);
        this.assertToken("%=", ETokenType.MODEQ);
        this.assertToken("&=", ETokenType.ANDEQ);
        this.assertToken("|=", ETokenType.OREQ);
        this.assertToken("^=", ETokenType.XOREQ);
        this.assertToken("<<=", ETokenType.LSHIFTEQ);
        this.assertToken(">>=", ETokenType.RSHIFTEQ);
        this.assertToken("**=", ETokenType.POWEREQ);
        this.assertToken("//=", ETokenType.FLOOR_DIVEQ);
    }

    public void testEmptyLine() throws IOException {
        this.assertTokens("test" + StringUtils.CR + StringUtils.CR + "test", ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.IDENTIFIER);
        this.assertTokens("test\r\n\r\ntest", ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.IDENTIFIER);
        this.assertTokens("test\n\ntest", ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.IDENTIFIER);
        this.assertTokens("test\r\rtest", ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.IDENTIFIER);
        this.assertTokens("test" + StringUtils.CR + "  \t" + StringUtils.CR + "test", ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.IDENTIFIER);
        this.assertTokens("test" + StringUtils.CR + "# comment" + StringUtils.CR + "test", ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.END_OF_LINE_COMMENT, ETokenType.EOL, ETokenType.IDENTIFIER);
    }

    private String indent(int length) {
        return StringUtils.fillString(length * 2, ' ');
    }

    public void testIndent() throws IOException {
        this.assertTokens(this.indent(1) + "test" + StringUtils.CR + this.indent(2) + "test", ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.DEDENT, ETokenType.DEDENT);
        this.assertTokens(this.indent(1) + "test" + StringUtils.CR + this.indent(2) + "test" + StringUtils.CR + this.indent(1) + "test", ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.DEDENT, ETokenType.IDENTIFIER, ETokenType.DEDENT);
        this.assertTokens(this.indent(1) + "test" + StringUtils.CR + this.indent(2) + "test" + StringUtils.CR + this.indent(3) + "test" + StringUtils.CR + this.indent(1) + "test", ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.DEDENT, ETokenType.DEDENT, ETokenType.IDENTIFIER, ETokenType.DEDENT);
        this.assertTokens(this.indent(0) + "test1" + StringUtils.CR + this.indent(1) + "test2" + StringUtils.CR + this.indent(0) + "test3", ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.DEDENT, ETokenType.IDENTIFIER);
        this.assertTokens("def parse_testfile(fname):" + StringUtils.CR + "    with open(fname) as fp:" + StringUtils.CR + "        for line in fp:" + StringUtils.CR + "class MathTests(unittest.TestCase):", ETokenType.DEF, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.COLON, ETokenType.EOL, ETokenType.INDENT, ETokenType.WITH, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.AS, ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.EOL, ETokenType.INDENT, ETokenType.FOR, ETokenType.IDENTIFIER, ETokenType.IN, ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.EOL, ETokenType.DEDENT, ETokenType.DEDENT, ETokenType.CLASS, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.COLON);
        this.assertTokens("\ttest" + StringUtils.CR + "\t  \ttest", ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.DEDENT, ETokenType.DEDENT);
        this.assertTokens("'''test1" + StringUtils.CR + "test2''' test3 '''test4" + StringUtils.CR + "test5'''", ETokenType.STRING_LITERAL, ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL);
        this.assertTokens("\"\"\"test1" + StringUtils.CR + "test2\"\"\" test3 \"\"\"test4" + StringUtils.CR + "test5\"\"\"", ETokenType.STRING_LITERAL, ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL);
        this.assertTokens("'\\n'", ETokenType.STRING_LITERAL);
        this.assertTokens("if contents and contents[-1] != '\\n':" + StringUtils.CR + "    f.write('\\n')", ETokenType.IF, ETokenType.IDENTIFIER, ETokenType.AND, ETokenType.IDENTIFIER, ETokenType.LBRACK, ETokenType.MINUS, ETokenType.INTEGER_LITERAL, ETokenType.RBRACK, ETokenType.NOTEQ, ETokenType.STRING_LITERAL, ETokenType.COLON, ETokenType.EOL, ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.STRING_LITERAL, ETokenType.RPAREN, ETokenType.DEDENT);
        this.assertTokens("  if context.rounding == ROUND_FLOOR and self._sign != other._sign:" + StringUtils.CR + "      # If the answer is 0, the sign should be negative, in this case." + StringUtils.CR + "      negativezero = 1" + StringUtils.CR + StringUtils.CR + "  if not self and not other:" + StringUtils.CR + "      sign = min(self._sign, other._sign)" + StringUtils.CR + "      if negativezero:" + StringUtils.CR + "          sign = 1" + StringUtils.CR + "      ans = _dec_from_triple(sign, '0', exp)" + StringUtils.CR + "      ans = ans._fix(context)" + StringUtils.CR + "      return ans" + StringUtils.CR + "  if not self:", ETokenType.INDENT, ETokenType.IF, ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.EQEQ, ETokenType.IDENTIFIER, ETokenType.AND, ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.NOTEQ, ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.EOL, ETokenType.END_OF_LINE_COMMENT, ETokenType.EOL, ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.INTEGER_LITERAL, ETokenType.EOL, ETokenType.DEDENT, ETokenType.IF, ETokenType.NOT, ETokenType.IDENTIFIER, ETokenType.AND, ETokenType.NOT, ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.EOL, ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.COMMA, ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.EOL, ETokenType.IF, ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.EOL, ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.INTEGER_LITERAL, ETokenType.EOL, ETokenType.DEDENT, ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.COMMA, ETokenType.STRING_LITERAL, ETokenType.COMMA, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.EOL, ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.EOL, ETokenType.RETURN, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.DEDENT, ETokenType.IF, ETokenType.NOT, ETokenType.IDENTIFIER, ETokenType.COLON, ETokenType.DEDENT);
        this.assertTokens("        test" + StringUtils.CR + StringUtils.CR + "##         # Netscape protocol doesn't allow non-special top level domains (such" + StringUtils.CR + "##         # as co.uk) in the domain attribute unless there are at least three", ETokenType.INDENT, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.END_OF_LINE_COMMENT, ETokenType.EOL, ETokenType.END_OF_LINE_COMMENT, ETokenType.DEDENT);
        this.assertTokens("DELAY = 0 # Set > 0 when testing a module other than _dummy_thread, such as" + StringUtils.CR + "          # the '_thread' module." + StringUtils.CR + StringUtils.CR + "class LockTests(unittest.TestCase):", ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.INTEGER_LITERAL, ETokenType.END_OF_LINE_COMMENT, ETokenType.EOL, ETokenType.END_OF_LINE_COMMENT, ETokenType.EOL, ETokenType.CLASS, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.COLON);
    }
}

