/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import org.conqat.lib.scanner.ILenientScanner;
import org.conqat.lib.scanner.IToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class QueuedScannerBase<E extends IToken>
implements ILenientScanner {
    private final Queue<E> queue = new LinkedList();

    QueuedScannerBase() {
    }

    public E getNextToken() throws IOException {
        if (!this.queue.isEmpty()) {
            return (E)((IToken)this.queue.poll());
        }
        return this.internalScan();
    }

    protected void pushToken(E token) {
        this.queue.add(token);
    }

    protected void pushTokens(E ... tokens) {
        this.queue.addAll(Arrays.asList(tokens));
    }

    protected abstract E internalScan() throws IOException;
}

