/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.IScanner;
import org.conqat.lib.scanner.ScannerException;
import org.conqat.lib.scanner.ScannerFactory;

public class ResetScannerTest
extends TestCase {
    public void testReset() throws IOException, ScannerException {
        for (ELanguage language : ELanguage.values()) {
            IScanner scanner = ScannerFactory.newScanner(language, "x", null);
            for (int i = 0; i < 100; ++i) {
                String input = "test" + i + " test" + i;
                if (language == ELanguage.PHP) {
                    input = "<? " + input;
                }
                scanner.reset(new StringReader(input), null);
                if (language == ELanguage.PHP) {
                    scanner.getNextToken();
                }
                String output = scanner.getNextToken().getText();
                ResetScannerTest.assertEquals((String)("test" + i), (String)output);
                output = scanner.getNextToken().getText();
                ResetScannerTest.assertEquals((String)("test" + i), (String)output);
            }
        }
    }
}

