/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ScannerTestBase;

public abstract class SQLScannerTestBase
extends ScannerTestBase {
    public void testComments() throws IOException {
        this.assertToken("-- Begin processing", ETokenType.END_OF_LINE_COMMENT);
        this.assertTokens("/* test comment " + StringUtils.CR + "test */", ETokenType.TRADITIONAL_COMMENT);
    }

    public void testErrorCases() throws IOException {
        this.assertTokens("'ua\n identifier", ETokenType.UNTERMINATED_STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'ua", ETokenType.UNTERMINATED_STRING_LITERAL, ETokenType.EOF);
    }

    public void testIdentifiers() throws IOException {
        String[] regular = new String[]{"abc", "X", "t2", "LastName", "firstName", "ALLCAPS"};
        this.batchAssertTokenType(regular, ETokenType.IDENTIFIER);
        String[] specialCharacters = new String[]{"phone#", "credit_limit", "oracle$number", "money$$$tree", "SN##", "try_again_"};
        this.batchAssertTokenType(specialCharacters, ETokenType.IDENTIFIER);
        String[] quotationMarkQuoted = new String[]{"\"X+Y\"", "\"last name\"", "\"on/off switch\"", "\"employee(s)\"", "\"*** header info ***\""};
        this.batchAssertTokenType(quotationMarkQuoted, ETokenType.IDENTIFIER);
    }

    public void testIntegerLiterals() throws IOException {
        String[] integerLiterals = new String[]{"030", "6", "-14", "0", "+32767"};
        this.batchAssertTokenType(integerLiterals, ETokenType.INTEGER_LITERAL);
    }

    public void testRealLiterals() throws IOException {
        String[] realLiterals = new String[]{"6.6667", "0.0", "-12.0", "3.14159", "+8300.00", ".5", "25.", "2E5", "1.0E-7", "3.14159e0", "-1E38", "-9.5e-3", "101.5E5"};
        this.batchAssertTokenType(realLiterals, ETokenType.FLOATING_POINT_LITERAL);
    }

    public void testCharacterLiterals() throws IOException {
        String[] charLiterals = new String[]{"'Z'", "'%'", "'7'", "' '", "'z'", "'('"};
        this.batchAssertTokenType(charLiterals, ETokenType.CHARACTER_LITERAL);
    }

    public void testStringLiterals() throws IOException {
        this.assertTokens("''", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'test' 'test'", ETokenType.STRING_LITERAL, ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'Hello, world!'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'XYZ Corporation'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'10-NOV-91'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'He said \"Life is like licking honey from a thorn.\"'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'$1,000,000'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'I''m a string, you''re a string.'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("q'!I'm a string, you're a string.!'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("nq'#WHERE COL_VALUE LIKE '%\u0000E9'#'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'test " + StringUtils.CR + " test'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("q'!I'm a string," + StringUtils.CR + " you're a string.!'", ETokenType.STRING_LITERAL, ETokenType.EOF);
        this.assertTokens("'test " + StringUtils.CR + " test' + test", ETokenType.STRING_LITERAL, ETokenType.PLUS, ETokenType.IDENTIFIER, ETokenType.EOF);
        this.assertTokens("test '" + StringUtils.CR + ", gFld('", ETokenType.IDENTIFIER, ETokenType.STRING_LITERAL, ETokenType.EOF);
    }

    public void testKeywords() throws IOException {
        this.assertToken("ALL", ETokenType.ALL);
        this.assertToken("ALTER", ETokenType.ALTER);
        this.assertToken("AND", ETokenType.AND);
        this.assertToken("ANY", ETokenType.ANY);
        this.assertToken("AS", ETokenType.AS);
        this.assertToken("ASC", ETokenType.ASC);
        this.assertToken("BEGIN", ETokenType.BEGIN);
        this.assertToken("BETWEEN", ETokenType.BETWEEN);
        this.assertToken("BY", ETokenType.BY);
        this.assertToken("CASE", ETokenType.CASE);
        this.assertToken("CHECK", ETokenType.CHECK);
        this.assertToken("CREATE", ETokenType.CREATE);
        this.assertToken("CURRENT", ETokenType.CURRENT);
        this.assertToken("DECLARE", ETokenType.DECLARE);
        this.assertToken("DEFAULT", ETokenType.DEFAULT);
        this.assertToken("DELETE", ETokenType.DELETE);
        this.assertToken("DESC", ETokenType.DESC);
        this.assertToken("DISTINCT", ETokenType.DISTINCT);
        this.assertToken("DROP", ETokenType.DROP);
        this.assertToken("ELSE", ETokenType.ELSE);
        this.assertToken("END", ETokenType.END);
        this.assertToken("EXISTS", ETokenType.EXISTS);
        this.assertToken("FETCH", ETokenType.FETCH);
        this.assertToken("FOR", ETokenType.FOR);
        this.assertToken("FROM", ETokenType.FROM);
        this.assertToken("GOTO", ETokenType.GOTO);
        this.assertToken("GRANT", ETokenType.GRANT);
        this.assertToken("GROUP", ETokenType.GROUP);
        this.assertToken("HAVING", ETokenType.HAVING);
        this.assertToken("IF", ETokenType.IF);
        this.assertToken("IN", ETokenType.IN);
        this.assertToken("INDEX", ETokenType.INDEX);
        this.assertToken("INSERT", ETokenType.INSERT);
        this.assertToken("INTERSECT", ETokenType.INTERSECT);
        this.assertToken("INTO", ETokenType.INTO);
        this.assertToken("IS", ETokenType.IS);
        this.assertToken("LIKE", ETokenType.LIKE);
        this.assertToken("NOT", ETokenType.NOT);
        this.assertToken("OF", ETokenType.OF);
        this.assertToken("ON", ETokenType.ON);
        this.assertToken("OPTION", ETokenType.OPTION);
        this.assertToken("OR", ETokenType.OR);
        this.assertToken("ORDER", ETokenType.ORDER);
        this.assertToken("PROCEDURE", ETokenType.PROCEDURE);
        this.assertToken("PUBLIC", ETokenType.PUBLIC);
        this.assertToken("REVOKE", ETokenType.REVOKE);
        this.assertToken("SELECT", ETokenType.SELECT);
        this.assertToken("TABLE", ETokenType.TABLE);
        this.assertToken("THEN", ETokenType.THEN);
        this.assertToken("TO", ETokenType.TO);
        this.assertToken("UNION", ETokenType.UNION);
        this.assertToken("UNIQUE", ETokenType.UNIQUE);
        this.assertToken("UPDATE", ETokenType.UPDATE);
        this.assertToken("VALUES", ETokenType.VALUES);
        this.assertToken("VIEW", ETokenType.VIEW);
        this.assertToken("WHEN", ETokenType.WHEN);
        this.assertToken("WHERE", ETokenType.WHERE);
        this.assertToken("WITH", ETokenType.WITH);
    }

    public void testOperators() throws IOException {
        this.assertToken("+", ETokenType.PLUS);
        this.assertToken("-", ETokenType.MINUS);
        this.assertToken("*", ETokenType.MULT);
        this.assertToken("/", ETokenType.DIV);
        this.assertToken("=", ETokenType.EQUAL);
        this.assertToken(">", ETokenType.GT);
        this.assertToken("<", ETokenType.LT);
        this.assertToken("<=", ETokenType.LTEQ);
        this.assertToken(">=", ETokenType.GTEQ);
        this.assertToken("!=", ETokenType.NEQ);
        this.assertToken("<>", ETokenType.NEQ);
    }

    public void testDelimiters() throws IOException {
        this.assertToken(".", ETokenType.DOT);
        this.assertToken("(", ETokenType.LPAREN);
        this.assertToken(")", ETokenType.RPAREN);
        this.assertToken(":", ETokenType.COLON);
        this.assertToken(",", ETokenType.COMMA);
        this.assertToken(";", ETokenType.SEMICOLON);
    }
}

