/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ILenientScanner;
import org.conqat.lib.scanner.IScanner;
import org.conqat.lib.scanner.IToken;
import org.conqat.lib.scanner.ScannerException;
import org.conqat.lib.scanner.ScannerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScannerUtils {
    public static void readTokens(IScanner scanner, List<IToken> tokens, List<ScannerException> exceptions) throws IOException {
        IToken token = null;
        do {
            try {
                token = scanner.getNextToken();
                if (token.getType() == ETokenType.EOF) continue;
                tokens.add(token);
            }
            catch (ScannerException e) {
                exceptions.add(e);
            }
        } while (token != null && token.getType() != ETokenType.EOF);
    }

    public static List<IToken> readTokens(ILenientScanner scanner) throws IOException {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        IToken token = null;
        while ((token = scanner.getNextToken()).getType() != ETokenType.EOF) {
            tokens.add(token);
        }
        return tokens;
    }

    public static List<IToken> getTokens(String content, ELanguage language) {
        return ScannerUtils.getTokens(content, language, "origin");
    }

    public static List<IToken> getTokens(String content, ELanguage language, String origin) {
        ILenientScanner scanner = ScannerFactory.newLenientScanner(language, content, origin);
        try {
            return ScannerUtils.readTokens(scanner);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"can not happen as the scanner is lenient and we are working from memory");
        }
    }
}

