/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.IToken;

public abstract class Token
implements IToken {
    protected final ETokenType type;
    protected final int offset;
    protected final int lineNumber;
    protected final String text;
    protected final String originId;

    protected Token(ETokenType type, int offset, int lineNumber, String text, String originId) {
        this.type = type;
        this.offset = offset;
        this.lineNumber = lineNumber;
        this.text = text;
        this.originId = originId;
    }

    public String toString() {
        String result = "TOKEN (" + (Object)((Object)this.type) + ") Text: >>" + this.text + "<<";
        result = result + " Origin: '" + this.originId + "' line#: " + this.lineNumber;
        return result;
    }

    public String getText() {
        return this.text;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getEndOffset() {
        return this.offset + this.text.length() - 1;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getOriginId() {
        return this.originId;
    }

    public ETokenType getType() {
        return this.type;
    }
}

