/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import junit.framework.TestCase;
import org.conqat.lib.scanner.UnicodeEscapeException;
import org.conqat.lib.scanner.UnicodeEscapes;

public class UnicodeEscapesTest
extends TestCase {
    private static int MIN_CODE = 0;
    private static int MAX_CODE = 65535;

    public void testRead() throws UnicodeEscapeException, IOException {
        String inputString = "test123";
        UnicodeEscapes unicodeScanner = new UnicodeEscapes(new StringReader(inputString));
        char[] chars = inputString.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            UnicodeEscapesTest.assertEquals((char)chars[i], (char)((char)unicodeScanner.read()));
        }
        UnicodeEscapesTest.assertEquals((int)-1, (int)unicodeScanner.read());
    }

    public void testReadBuf() throws UnicodeEscapeException, IOException {
        String inputString = "test123";
        this.checkSameAsStringReader(inputString, 0, inputString.length());
        this.checkSameAsStringReader(inputString, 0, inputString.length() - 2);
        this.checkSameAsStringReader(inputString, 0, inputString.length() + 5);
        this.checkSameAsStringReader(inputString, 0, inputString.length());
        this.checkSameAsStringReader(inputString, 0, inputString.length() - 1);
        this.checkSameAsStringReader(inputString, 0, inputString.length() + 1);
        this.checkSameAsStringReader(inputString, 10, inputString.length());
        this.checkSameAsStringReader(inputString, 10, inputString.length() - 2);
        this.checkSameAsStringReader(inputString, 10, inputString.length() + 2);
    }

    public void testReadBuf2() throws IOException {
        String inputString = "true";
        UnicodeEscapes scanner = new UnicodeEscapes(new StringReader(inputString));
        char[] buffer = new char[1024];
        UnicodeEscapesTest.assertEquals((int)inputString.length(), (int)((Reader)scanner).read(buffer, 0, buffer.length));
        UnicodeEscapesTest.assertEquals((int)-1, (int)((Reader)scanner).read(buffer, inputString.length(), buffer.length - inputString.length()));
    }

    public void testResetting() throws IOException {
        String input = this.createStringWithAllUnicodeEscapes();
        UnicodeEscapes unicodeScanner = new UnicodeEscapes(new StringReader(input));
        this.check(unicodeScanner);
        unicodeScanner.yyreset(new StringReader(input));
        this.check(unicodeScanner);
    }

    public void testResolveUnicodes() throws IOException {
        String input = this.createStringWithAllUnicodeEscapes();
        UnicodeEscapes unicodeScanner = new UnicodeEscapes(new StringReader(input));
        this.check(unicodeScanner);
    }

    private void assertEquals(char[] expected, char[] actual, int offset, int len) {
        for (int i = offset; i < offset + len; ++i) {
            UnicodeEscapesTest.assertEquals((char)expected[i], (char)actual[i]);
        }
    }

    private String calcUnicodeEscape(int i) {
        String hexCode = Integer.toHexString(i);
        int leadingZerosCount = 4 - hexCode.length();
        char[] leadingZeros = new char[leadingZerosCount];
        Arrays.fill(leadingZeros, '0');
        String leadingZerosString = new String(leadingZeros);
        String unicodeEscape = "\\u" + leadingZerosString + hexCode;
        return unicodeEscape;
    }

    private void check(UnicodeEscapes unicodeResolver) throws IOException {
        int value;
        int counter = 0;
        while ((value = unicodeResolver.read()) != -1) {
            UnicodeEscapesTest.assertEquals((int)(counter + MIN_CODE), (int)value);
            ++counter;
        }
    }

    private void checkSameAsStringReader(String inputString, int offset, int len) throws IOException {
        StringReader stringReader = new StringReader(inputString);
        UnicodeEscapes scanner = new UnicodeEscapes(new StringReader(inputString));
        char[] stringReaderBuffer = new char[1024];
        char[] scannerBuffer = new char[1024];
        UnicodeEscapesTest.assertEquals((int)stringReader.read(stringReaderBuffer, offset, len), (int)scanner.read(scannerBuffer, offset, len));
        this.assertEquals(stringReaderBuffer, scannerBuffer, offset, len);
        UnicodeEscapesTest.assertEquals((int)stringReader.read(stringReaderBuffer), (int)scanner.read(scannerBuffer));
    }

    private String createStringWithAllUnicodeEscapes() {
        StringBuilder builder = new StringBuilder();
        for (int i = MIN_CODE; i <= MAX_CODE; ++i) {
            builder.append(this.calcUnicodeEscape(i));
        }
        return builder.toString();
    }
}

