/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ScannerTestBase;

public class VBScannerTest
extends ScannerTestBase {
    protected ELanguage getLanguage() {
        return ELanguage.VB;
    }

    public void testErrorCases() throws IOException {
        this.assertTokens("\"ac \n identifier", ETokenType.ILLEGAL_CHARACTER, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.IDENTIFIER, ETokenType.EOF);
        this.assertTokens("\"identifier", ETokenType.ILLEGAL_CHARACTER, ETokenType.IDENTIFIER, ETokenType.EOF);
        this.assertTokens("\"a \n identifier", ETokenType.ILLEGAL_CHARACTER, ETokenType.IDENTIFIER, ETokenType.EOL, ETokenType.IDENTIFIER, ETokenType.EOF);
    }

    public void testCharacterLiteral() throws IOException {
        this.assertToken("\"a\"c", ETokenType.CHARACTER_LITERAL);
    }

    public void testIntegerLiteral() throws IOException {
        this.assertToken("0", ETokenType.INTEGER_LITERAL);
        this.assertToken("1", ETokenType.INTEGER_LITERAL);
        this.assertToken("123", ETokenType.INTEGER_LITERAL);
    }

    public void testHexIntegerLiteral() throws IOException {
        this.assertToken("&HA0", ETokenType.INTEGER_LITERAL);
    }

    public void testFloatLiteral() throws IOException {
        this.assertToken("0.0f", ETokenType.FLOATING_POINT_LITERAL);
        this.assertToken("0.5f", ETokenType.FLOATING_POINT_LITERAL);
    }

    public void testBoolLiteral() throws IOException {
        this.assertToken("True", ETokenType.BOOLEAN_LITERAL);
        this.assertToken("False", ETokenType.BOOLEAN_LITERAL);
    }

    public void testSimpleStringLiteral() throws IOException {
        this.assertToken("\"test\"", ETokenType.STRING_LITERAL);
    }

    public void testDateLiteral() throws IOException {
        this.assertToken("# 8/23/1970 3:45:39AM #", ETokenType.DATE_LITERAL);
        this.assertToken("# 8/23/1970 #", ETokenType.DATE_LITERAL);
        this.assertToken("# 3:45:39AM #", ETokenType.DATE_LITERAL);
        this.assertToken("# 3:45:39 #", ETokenType.DATE_LITERAL);
        this.assertToken("# 13:45:39 #", ETokenType.DATE_LITERAL);
    }

    public void testBrackets() throws IOException {
        this.assertTokens("[", ETokenType.LBRACK);
        this.assertTokens("]", ETokenType.RBRACK);
        this.assertTokens("ColumnWidth[0].Value=5292", ETokenType.IDENTIFIER, ETokenType.LBRACK, ETokenType.INTEGER_LITERAL, ETokenType.RBRACK, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.INTEGER_LITERAL);
    }

    public void testComments() throws IOException {
        this.assertToken("' test", ETokenType.END_OF_LINE_COMMENT);
        this.assertToken("REM test", ETokenType.END_OF_LINE_COMMENT);
    }

    public void testIllegalUnterminatedStringLiteral() throws IOException {
        String testString = "\"test\ntest2";
        VBScannerTest.assertTrue((boolean)this.findProblem(testString));
    }

    public void testIllegalUnterminatedStringLiteral2() throws IOException {
        String testString = "test\"\ntest2";
        VBScannerTest.assertTrue((boolean)this.findProblem(testString));
    }
}

