/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner;

import java.io.IOException;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ScannerTestBase;

public class XMLScannerTest
extends ScannerTestBase {
    protected ELanguage getLanguage() {
        return ELanguage.XML;
    }

    public void testStartTag() throws IOException {
        this.assertTokens("<start>", ETokenType.LEFT_ANGLE_BRACKET, ETokenType.XML_NAME, ETokenType.RIGHT_ANGLE_BRACKET);
    }

    public void testNamespace() throws IOException {
        this.assertTokens("<link xlink:href='http://www.olev.org'>", ETokenType.LEFT_ANGLE_BRACKET, ETokenType.XML_NAME, ETokenType.XML_NAME, ETokenType.EQ, ETokenType.STRING_LITERAL, ETokenType.RIGHT_ANGLE_BRACKET);
    }

    public void testMixedContent() throws IOException {
        this.assertTokens("<paragraph> <olev/> abc </paragraph>", ETokenType.LEFT_ANGLE_BRACKET, ETokenType.XML_NAME, ETokenType.RIGHT_ANGLE_BRACKET, ETokenType.LEFT_ANGLE_BRACKET, ETokenType.XML_NAME, ETokenType.SLASH, ETokenType.RIGHT_ANGLE_BRACKET, ETokenType.STRING_LITERAL, ETokenType.LEFT_ANGLE_BRACKET, ETokenType.SLASH, ETokenType.XML_NAME, ETokenType.RIGHT_ANGLE_BRACKET);
    }

    public void testAttribute() throws IOException {
        this.assertTokens("attr = \"value\"", ETokenType.XML_NAME, ETokenType.EQ, ETokenType.STRING_LITERAL);
        this.assertTokens("attr = 'value'", ETokenType.XML_NAME, ETokenType.EQ, ETokenType.STRING_LITERAL);
        this.assertTokens("attr = 'value &test; &#32; &#xfff;'", ETokenType.XML_NAME, ETokenType.EQ, ETokenType.STRING_LITERAL);
    }

    public void testComment() throws IOException {
        this.assertToken("<!-- This is a coment - another one -->", ETokenType.TRADITIONAL_COMMENT);
    }

    public void testContent() throws IOException {
        this.assertTokens("<start>test</start>", ETokenType.LEFT_ANGLE_BRACKET, ETokenType.XML_NAME, ETokenType.RIGHT_ANGLE_BRACKET, ETokenType.STRING_LITERAL, ETokenType.LEFT_ANGLE_BRACKET, ETokenType.SLASH, ETokenType.XML_NAME, ETokenType.RIGHT_ANGLE_BRACKET);
        this.assertTokens("<start>test 123</start>", ETokenType.LEFT_ANGLE_BRACKET, ETokenType.XML_NAME, ETokenType.RIGHT_ANGLE_BRACKET, ETokenType.STRING_LITERAL, ETokenType.LEFT_ANGLE_BRACKET, ETokenType.SLASH, ETokenType.XML_NAME, ETokenType.RIGHT_ANGLE_BRACKET);
        this.assertTokens("<start>test \"123\"</start>", ETokenType.LEFT_ANGLE_BRACKET, ETokenType.XML_NAME, ETokenType.RIGHT_ANGLE_BRACKET, ETokenType.STRING_LITERAL, ETokenType.LEFT_ANGLE_BRACKET, ETokenType.SLASH, ETokenType.XML_NAME, ETokenType.RIGHT_ANGLE_BRACKET);
        this.assertTokens("<paragraph><link/></paragraph>", ETokenType.LEFT_ANGLE_BRACKET, ETokenType.XML_NAME, ETokenType.RIGHT_ANGLE_BRACKET, ETokenType.LEFT_ANGLE_BRACKET, ETokenType.XML_NAME, ETokenType.SLASH, ETokenType.RIGHT_ANGLE_BRACKET, ETokenType.LEFT_ANGLE_BRACKET, ETokenType.SLASH, ETokenType.XML_NAME, ETokenType.RIGHT_ANGLE_BRACKET);
    }

    public void testCDataSection() throws IOException {
        this.assertTokens("<start><![CDATA[<greeting>Hello, world!</greeting>]]></start>", ETokenType.LEFT_ANGLE_BRACKET, ETokenType.XML_NAME, ETokenType.RIGHT_ANGLE_BRACKET, ETokenType.STRING_LITERAL, ETokenType.LEFT_ANGLE_BRACKET, ETokenType.SLASH, ETokenType.XML_NAME, ETokenType.RIGHT_ANGLE_BRACKET);
    }

    public void testErrorCases() {
    }

    public void testIllegalCharacter() throws IOException {
        this.assertTokens("<test\u037e test", ETokenType.LEFT_ANGLE_BRACKET, ETokenType.XML_NAME, ETokenType.ILLEGAL_CHARACTER, ETokenType.XML_NAME, ETokenType.EOF);
        this.assertTokens("- <test", ETokenType.ILLEGAL_CHARACTER, ETokenType.LEFT_ANGLE_BRACKET, ETokenType.XML_NAME, ETokenType.EOF);
    }

    public void testEntityDefinitions() throws IOException {
        this.assertTokens("<!DOCTYPE conqat [  <!ENTITY ext-clonedetective SYSTEM 'conqat.clonedetective.xml'>]>", ETokenType.LEFT_ANGLE_BRACKET, ETokenType.EXCLAMATION, ETokenType.XML_NAME, ETokenType.XML_NAME, ETokenType.LBRACK, ETokenType.LEFT_ANGLE_BRACKET, ETokenType.EXCLAMATION, ETokenType.XML_NAME, ETokenType.XML_NAME, ETokenType.XML_NAME, ETokenType.STRING_LITERAL, ETokenType.RIGHT_ANGLE_BRACKET, ETokenType.RBRACK, ETokenType.RIGHT_ANGLE_BRACKET);
    }

    public void testProcessingInstructions() throws IOException {
        this.assertTokens("<?xml version='1.0'>", ETokenType.LEFT_ANGLE_BRACKET, ETokenType.QUESTION, ETokenType.XML_NAME, ETokenType.XML_NAME, ETokenType.EQ, ETokenType.STRING_LITERAL, ETokenType.RIGHT_ANGLE_BRACKET);
        this.assertTokens("<!DOCTYPE coverage SYSTEM \"http://cobertura.sourceforge.net/xml/coverage-02.dtd\">", ETokenType.LEFT_ANGLE_BRACKET, ETokenType.EXCLAMATION, ETokenType.XML_NAME, ETokenType.XML_NAME, ETokenType.XML_NAME, ETokenType.STRING_LITERAL, ETokenType.RIGHT_ANGLE_BRACKET);
    }
}

