/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner.regression;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.test.CCSMTestCaseBase;
import org.conqat.lib.commons.test.TestletBase;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.IScanner;
import org.conqat.lib.scanner.IToken;
import org.conqat.lib.scanner.ScannerException;
import org.conqat.lib.scanner.ScannerFactory;
import org.junit.Ignore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Ignore
public class RegressionTestlet
extends TestletBase {
    private IScanner scanner;
    private File file;
    private String fileContent;
    private final ELanguage language;
    private final File results;
    private final String testDirName;
    private File sourceoutdir;
    private File resultsoutdir;

    public IScanner getScanner() {
        return this.scanner;
    }

    public RegressionTestlet(File source, File results, String testDirName, ELanguage language) {
        this.file = source;
        this.results = results;
        this.language = language;
        this.testDirName = testDirName;
    }

    private File getTestTmpDirectory() {
        return new File(this.getTmpDirectory(), this.language.toString().toLowerCase() + File.separator + this.testDirName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.sourceoutdir = new File(this.getTestTmpDirectory(), File.separator + "source");
        FileSystemUtils.ensureDirectoryExists(this.sourceoutdir);
        FileSystemUtils.unjar(this.file, this.sourceoutdir);
        this.resultsoutdir = new File(this.getTestTmpDirectory(), File.separator + "results");
        FileSystemUtils.ensureDirectoryExists(this.resultsoutdir);
        FileSystemUtils.unjar(this.results, this.resultsoutdir);
    }

    @Override
    public void test() throws IOException {
        File output;
        List<File> files = FileSystemUtils.listFilesRecursively(this.sourceoutdir, new SourceFileFilter());
        boolean missedCompare = false;
        HashMap<File, List<String>> fileTokenMap = new HashMap<File, List<String>>();
        for (File file : files) {
            if (file.isDirectory()) continue;
            output = this.getTokenOutputFile(file);
            fileTokenMap.put(file, this.getTokenIdentsAndWriteToOutput(file, output));
        }
        for (File file : files) {
            if (file.isDirectory()) continue;
            output = this.getTokenOutputFile(file);
            File compare = new File(output.getAbsolutePath().replaceFirst("newresults", "results"));
            String[] content = null;
            if (compare.exists()) {
                content = FileSystemUtils.readFileUTF8(compare).split("\n");
            } else {
                missedCompare = true;
                System.err.println("Missing comparison file: " + compare);
            }
            int count = 0;
            if (content == null) continue;
            for (String tokenIdent : (List)fileTokenMap.get(file)) {
                RegressionTestlet.assertEquals((String)("Problem on line " + count + ": " + file.getName()), (String)tokenIdent, (String)content[count]);
                ++count;
            }
        }
        if (missedCompare) {
            RegressionTestlet.assertTrue((String)"Missing comparison files. Is results.zip missing/outdated?", (boolean)false);
        }
    }

    private File getTokenOutputFile(File file) {
        String outputFile = file.getAbsolutePath().replaceFirst("source", "newresults");
        outputFile = outputFile + ".tokens";
        File output = new File(outputFile);
        return output;
    }

    public List<String> getTokenIdentsAndWriteToOutput(File file, File output) throws IOException {
        ArrayList<String> tokenStrings = new ArrayList<String>();
        this.fileContent = FileSystemUtils.readFileUTF8(file);
        this.scanner = ScannerFactory.newScanner(this.language, this.fileContent, file.getAbsolutePath());
        FileSystemUtils.ensureParentDirectoryExists(output);
        StringBuilder builder = new StringBuilder();
        try {
            IToken token;
            while ((token = this.scanner.getNextToken()).getType() != ETokenType.EOF) {
                String tokenIdent = (Object)((Object)token.getType()) + ":Line:" + token.getLineNumber() + ":Offset:" + token.getOffset() + ":Text:" + token.getText().replaceAll("\n", "%LINEBREAK%");
                tokenStrings.add(tokenIdent);
                builder.append(tokenIdent).append("\n");
            }
            FileSystemUtils.writeFileUTF8(output, builder.toString());
        }
        catch (ScannerException e) {
            System.err.println("Error while scanning: " + file);
            e.printStackTrace();
        }
        return tokenStrings;
    }

    public String getName() {
        return this.file.getAbsolutePath();
    }

    protected static TestSuite createRegressionTestSuite(ELanguage language) {
        HashMap<File, FileTuple> files = RegressionTestlet.findFiles(new TestDataLocator().getDirectory(language));
        TestSuite suite = new TestSuite("RegressionTest");
        suite.setName((Object)((Object)language) + " Regression Test [" + files.size() + " test files]");
        for (Map.Entry<File, FileTuple> pair : files.entrySet()) {
            suite.addTest((Test)new RegressionTestlet(pair.getValue().f1, pair.getValue().f2, pair.getKey().getName(), language));
        }
        return suite;
    }

    private static HashMap<File, FileTuple> findFiles(File directory) {
        HashMap<File, FileTuple> result = new HashMap<File, FileTuple>();
        for (File file : directory.listFiles()) {
            if (!file.isDirectory()) continue;
            File source = new File(file, "source.zip");
            File results = new File(file, "results.zip");
            if (!source.exists() || !results.exists()) continue;
            result.put(file, new FileTuple(source, results));
        }
        return result;
    }

    private static class FileTuple {
        public final File f1;
        public final File f2;

        public FileTuple(File f1, File f2) {
            this.f1 = f1;
            this.f2 = f2;
        }
    }

    private static class TestDataLocator
    extends CCSMTestCaseBase {
        private TestDataLocator() {
        }

        public File getDirectory(ELanguage language) {
            return this.useTestFile(language.name().toLowerCase());
        }
    }

    private final class SourceFileFilter
    implements FileFilter {
        private SourceFileFilter() {
        }

        public boolean accept(File pathname) {
            for (String ext : RegressionTestlet.this.language.getFileExtensions()) {
                if (!pathname.getName().endsWith("." + ext)) continue;
                return true;
            }
            return false;
        }
    }
}

