/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.scanner.smoke;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.test.CCSMTestCaseBase;
import org.conqat.lib.commons.test.TestletBase;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.IScanner;
import org.conqat.lib.scanner.IToken;
import org.conqat.lib.scanner.ScannerException;
import org.conqat.lib.scanner.ScannerFactory;
import org.junit.Ignore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Ignore
public class SmokeTestlet
extends TestletBase {
    private IScanner scanner;
    private final File file;
    private String fileContent;
    private final ELanguage language;

    public SmokeTestlet(File file, ELanguage language) {
        this.file = file;
        this.language = language;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fileContent = FileSystemUtils.readFile(this.file);
        this.scanner = ScannerFactory.newScanner(this.language, this.fileContent, this.file.getAbsolutePath());
    }

    @Override
    public void test() throws IOException {
        try {
            IToken token;
            while ((token = this.scanner.getNextToken()).getType() != ETokenType.EOF) {
                int offset = token.getOffset();
                int length = token.getText().length();
                String source = this.fileContent.substring(offset, offset + length);
                SmokeTestlet.assertEquals((String)"Unexpected token content: ", (String)token.getText(), (String)source);
            }
        }
        catch (ScannerException e) {
            SmokeTestlet.fail((String)(e.getMessage() + " in file " + this.file));
        }
    }

    public String getName() {
        return this.file.getAbsolutePath();
    }

    protected static TestSuite createSmokeTestSuite(ELanguage language) {
        List<File> files = SmokeTestlet.findFiles(new TestDataLocator().getDirectory(language));
        TestSuite suite = new TestSuite("SmokeTest");
        suite.setName((Object)((Object)language) + " Smoke Test [" + files.size() + " test files]");
        for (File file : files) {
            suite.addTest((Test)new SmokeTestlet(file, language));
        }
        return suite;
    }

    private static List<File> findFiles(File directory) {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : directory.listFiles()) {
            if (!file.isFile() || file.getName().indexOf(".svn") >= 0) continue;
            result.add(file);
        }
        return result;
    }

    private static class TestDataLocator
    extends CCSMTestCaseBase {
        private TestDataLocator() {
        }

        public File getDirectory(ELanguage language) {
            return this.useTestFile(language.name().toLowerCase());
        }
    }
}

