/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPrintInfo;
import org.eclipse.swt.internal.cocoa.NSPrintOperation;
import org.eclipse.swt.internal.cocoa.NSPrinter;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.PMResolution;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    PrinterData data;
    NSPrinter printer;
    NSPrintInfo printInfo;
    NSPrintOperation operation;
    NSView view;
    NSWindow window;
    boolean isGCCreated;
    static final String DRIVER = "Mac";

    public static PrinterData[] getPrinterList() {
        PrinterData[] printerDataArray;
        block4: {
            NSAutoreleasePool pool = null;
            if (!NSThread.isMainThread()) {
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                NSArray printers = NSPrinter.printerNames();
                int count = (int)printers.count();
                PrinterData[] result = new PrinterData[count];
                int i = 0;
                while (i < count) {
                    NSString str = new NSString(printers.objectAtIndex(i));
                    result[i] = new PrinterData(DRIVER, str.getString());
                    ++i;
                }
                printerDataArray = result;
                Object var6_7 = null;
                if (pool == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var6_8 = null;
                    if (pool == null) break block5;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return printerDataArray;
    }

    public static PrinterData getDefaultPrinterData() {
        PrinterData printerData;
        block6: {
            NSPrinter printer;
            NSAutoreleasePool pool;
            block4: {
                block5: {
                    pool = null;
                    if (!NSThread.isMainThread()) {
                        pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        printer = NSPrintInfo.defaultPrinter();
                        if (printer != null) break block4;
                        Object var3_2 = null;
                        if (pool == null) break block5;
                    }
                    catch (Throwable throwable) {
                        block7: {
                            Object var3_4 = null;
                            if (pool == null) break block7;
                            pool.release();
                        }
                        throw throwable;
                    }
                    pool.release();
                }
                return null;
            }
            NSString str = printer.name();
            printerData = new PrinterData(DRIVER, str.getString());
            Object var3_3 = null;
            if (pool == null) break block6;
            pool.release();
        }
        return printerData;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData data) {
        super(Printer.checkNull(data));
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle rectangle;
        block3: {
            this.checkDevice();
            NSAutoreleasePool pool = null;
            if (!NSThread.isMainThread()) {
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                NSSize paperSize = this.printInfo.paperSize();
                NSRect bounds = this.printInfo.imageablePageBounds();
                Point dpi = this.getDPI();
                Point screenDPI = this.getIndependentDPI();
                float scaling = this.scalingFactor();
                x = (int)((double)x - bounds.x * (double)dpi.x / (double)screenDPI.x / (double)scaling);
                y = (int)((double)y - bounds.y * (double)dpi.y / (double)screenDPI.y / (double)scaling);
                width = (int)((double)width + (paperSize.width - bounds.width) * (double)dpi.x / (double)screenDPI.x / (double)scaling);
                height = (int)((double)height + (paperSize.height - bounds.height) * (double)dpi.y / (double)screenDPI.y / (double)scaling);
                rectangle = new Rectangle(x, y, width, height);
                Object var11_12 = null;
                if (pool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var11_13 = null;
                    if (pool == null) break block4;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return rectangle;
    }

    /*
     * Exception decompiling
     */
    protected void create(DeviceData deviceData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 571->575)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void destroy() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 140->144)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long internal_new_GC(GCData data) {
        long l;
        block6: {
            if (this.isDisposed()) {
                SWT.error(44);
            }
            NSAutoreleasePool pool = null;
            if (!NSThread.isMainThread()) {
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                if (data != null) {
                    if (this.isGCCreated) {
                        SWT.error(5);
                    }
                    data.device = this;
                    data.background = this.getSystemColor((int)1).handle;
                    data.foreground = this.getSystemColor((int)2).handle;
                    data.font = this.getSystemFont();
                    float scaling = this.scalingFactor();
                    Point dpi = this.getDPI();
                    Point screenDPI = this.getIndependentDPI();
                    NSSize size = this.printInfo.paperSize();
                    size.width = size.width * (double)(dpi.x / screenDPI.x) / (double)scaling;
                    size.height = size.height * (double)dpi.y / (double)screenDPI.y / (double)scaling;
                    data.size = size;
                    this.isGCCreated = true;
                }
                this.createContext();
                l = this.operation.context().id;
                Object var7_8 = null;
                if (pool == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var7_9 = null;
                    if (pool == null) break block7;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return l;
    }

    /*
     * Exception decompiling
     */
    protected void init() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 49->53)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void internal_dispose_GC(long context, GCData data) {
        if (data != null) {
            this.isGCCreated = false;
        }
    }

    protected void release() {
        super.release();
    }

    float scalingFactor() {
        NSNumber scale = new NSNumber(this.printInfo.dictionary().objectForKey(OS.NSPrintScalingFactor));
        return OS.PTR_SIZEOF == 4 ? scale.floatValue() : (float)scale.doubleValue();
    }

    public boolean startJob(String jobName) {
        block7: {
            NSAutoreleasePool pool;
            block5: {
                block6: {
                    this.checkDevice();
                    pool = null;
                    if (!NSThread.isMainThread()) {
                        pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        if (jobName != null && jobName.length() != 0) {
                            this.operation.setJobTitle(NSString.stringWith(jobName));
                        }
                        if (!this.createContext()) break block5;
                        this.view.beginDocument();
                        Object var3_3 = null;
                        if (pool == null) break block6;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var3_5 = null;
                            if (pool == null) break block8;
                            pool.release();
                        }
                        throw throwable;
                    }
                    pool.release();
                }
                return true;
            }
            Object var3_4 = null;
            if (pool == null) break block7;
            pool.release();
        }
        return false;
    }

    boolean createContext() {
        if (this.operation.context() != null) {
            return true;
        }
        this.printInfo.setUpPrintOperationDefaultValues();
        NSPrintOperation.setCurrentOperation(this.operation);
        return this.operation.createContext() != null;
    }

    /*
     * Exception decompiling
     */
    public void endJob() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 78->82)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void cancelJob() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 63->67)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static DeviceData checkNull(PrinterData data) {
        if (data == null) {
            data = new PrinterData();
        }
        if (data.driver == null || data.name == null) {
            PrinterData defaultPrinter = Printer.getDefaultPrinterData();
            if (defaultPrinter == null) {
                SWT.error(2);
            }
            data.driver = defaultPrinter.driver;
            data.name = defaultPrinter.name;
        }
        return data;
    }

    public boolean startPage() {
        block3: {
            this.checkDevice();
            NSAutoreleasePool pool = null;
            if (!NSThread.isMainThread()) {
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                float scaling = this.scalingFactor();
                NSSize paperSize = this.printInfo.paperSize();
                paperSize.width /= (double)scaling;
                paperSize.height /= (double)scaling;
                NSRect rect = new NSRect();
                rect.width = paperSize.width;
                rect.height = paperSize.height;
                this.view.beginPageInRect(rect, new NSPoint());
                NSRect imageBounds = this.printInfo.imageablePageBounds();
                imageBounds.x /= (double)scaling;
                imageBounds.y /= (double)scaling;
                imageBounds.width /= (double)scaling;
                imageBounds.height /= (double)scaling;
                NSBezierPath.bezierPathWithRect(imageBounds).setClip();
                NSAffineTransform transform = NSAffineTransform.transform();
                transform.translateXBy(imageBounds.x, imageBounds.y);
                Point dpi = this.getDPI();
                Point screenDPI = this.getIndependentDPI();
                transform.scaleXBy((float)screenDPI.x / (float)dpi.x, (float)screenDPI.y / (float)dpi.y);
                transform.concat();
                this.operation.context().saveGraphicsState();
                Object var9_9 = null;
                if (pool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var9_10 = null;
                    if (pool == null) break block4;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public void endPage() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 66->70)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Point getDPI() {
        Point point;
        block9: {
            NSAutoreleasePool pool;
            block7: {
                Point point2;
                block8: {
                    this.checkDevice();
                    pool = null;
                    if (!NSThread.isMainThread()) {
                        pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                    }
                    try {
                        int[] numberOfResolutions;
                        short[] destType;
                        long printSettings;
                        long pmPrintSession = this.printInfo.PMPrintSession();
                        long[] printer = new long[1];
                        long err = OS.PMSessionGetCurrentPrinter(pmPrintSession, printer);
                        if (err != 0L || OS.PMSessionGetDestinationType(pmPrintSession, printSettings = this.printInfo.PMPrintSettings(), destType = new short[1]) != 0L || destType[0] != 1) break block7;
                        PMResolution resolution = new PMResolution();
                        if (OS.PMPrinterGetOutputResolution(printer[0], printSettings, resolution) != 0L && OS.PMPrinterGetPrinterResolutionCount(printer[0], numberOfResolutions = new int[1]) == 0L) {
                            PMResolution tempResolution = new PMResolution();
                            tempResolution.vRes = 300.0;
                            tempResolution.hRes = 300.0;
                            int i = 1;
                            while (i <= numberOfResolutions[0]) {
                                if (OS.PMPrinterGetIndexedPrinterResolution(printer[0], i, tempResolution) == 0L && tempResolution.vRes > resolution.vRes && tempResolution.hRes > resolution.hRes) {
                                    resolution = tempResolution;
                                }
                                ++i;
                            }
                        }
                        point2 = new Point((int)resolution.hRes, (int)resolution.vRes);
                        Object var14_13 = null;
                        if (pool == null) break block8;
                    }
                    catch (Throwable throwable) {
                        block10: {
                            Object var14_15 = null;
                            if (pool == null) break block10;
                            pool.release();
                        }
                        throw throwable;
                    }
                    pool.release();
                }
                return point2;
            }
            point = this.getIndependentDPI();
            Object var14_14 = null;
            if (pool == null) break block9;
            pool.release();
        }
        return point;
    }

    Point getIndependentDPI() {
        return super.getDPI();
    }

    public Rectangle getBounds() {
        Rectangle rectangle;
        block3: {
            this.checkDevice();
            NSAutoreleasePool pool = null;
            if (!NSThread.isMainThread()) {
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                NSSize size = this.printInfo.paperSize();
                float scaling = this.scalingFactor();
                Point dpi = this.getDPI();
                Point screenDPI = this.getIndependentDPI();
                rectangle = new Rectangle(0, 0, (int)(size.width * (double)dpi.x / (double)screenDPI.x / (double)scaling), (int)(size.height * (double)dpi.y / (double)screenDPI.y / (double)scaling));
                Object var6_7 = null;
                if (pool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_8 = null;
                    if (pool == null) break block4;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return rectangle;
    }

    public Rectangle getClientArea() {
        Rectangle rectangle;
        block3: {
            this.checkDevice();
            NSAutoreleasePool pool = null;
            if (!NSThread.isMainThread()) {
                pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            }
            try {
                float scaling = this.scalingFactor();
                NSRect rect = this.printInfo.imageablePageBounds();
                Point dpi = this.getDPI();
                Point screenDPI = this.getIndependentDPI();
                rectangle = new Rectangle(0, 0, (int)(rect.width * (double)dpi.x / (double)screenDPI.x / (double)scaling), (int)(rect.height * (double)dpi.y / (double)screenDPI.y / (double)scaling));
                Object var6_7 = null;
                if (pool == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_8 = null;
                    if (pool == null) break block4;
                    pool.release();
                }
                throw throwable;
            }
            pool.release();
        }
        return rectangle;
    }

    public PrinterData getPrinterData() {
        this.checkDevice();
        return this.data;
    }
}

