# Summary

The data of our study:

```
@INPROCEEDINGS{9054802,
  author    = {Steinbeck, Marcel and Koschke, Rainer and R{\"u}del, Marc O.},
  booktitle = {2020 IEEE 27th International Conference on Software Analysis,
               Evolution and Reengineering (SANER)}, 
  title={How EvoStreets Are Observed in Three-Dimensional and Virtual Reality
         Environments}, 
  year={2020},
  volume={},
  number={},
  pages={332-343},
  doi={10.1109/SANER48275.2020.9054802}
}
```

In the following, we describe the structure of the CSV files `TaskData.csv` and
`ViewPoints.csv`.

# TaskData.csv

Contains the movement data of the participants.

- Subject: The participant (p02--p34).
- Task: Task to be solved by the participant.
- X, Y, Z: The coordinates of the participant at a certain point in time.
  The values are in centimeter. Z represents the height.
- Environment: Whether the task was set in 2.5D or VR.
- DeltaMS: Time (in milliseconds) the participant stayed at `X`, `Y`, `Z`.
- TimeMS: Time (in milliseconds) when participant moved to the next location.
  Accumulates `DeltaMS`.

# ViewPoints.csv

Contains the view points of the participants (extracted from
`TaskData.csv`).

- Subject: The participant (p02--p34).
- Task: Task to be solved by the participant.
- X, Y, Z: Location of the view point.
  The values are in centimeter. Z represents the height.
- Environment: Whether the task was set in 2.5D or VR.
- Duration: Residence time (in milliseconds) of the view point.
- StartTime, CenterTime, EndTime: The mapping strategy.
  See Section IV B. Times are in milliseconds.
- Threshold: Threshold used to extract the view point.
